/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import org.jetbrains.annotations.NotNull;

public class AncientWitchHut
extends StructureFeature<JigsawConfiguration> {
    private static final ResourceLocation START_POOL = new ResourceLocation("endrem", "ancient_witch_hut/start_pool");
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.f_20524_, 5, 5, 10), (Object)new CustomMonsterSpawn(EntityType.f_20495_, 10, 10, 15));

    public AncientWitchHut(Codec<JigsawConfiguration> codec) {
        super(codec, AncientWitchHut::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.ANCIENT_WITCH_HUT.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(MobCategory.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    @NotNull
    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        JigsawConfiguration newConfig = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(START_POOL), 1);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        BlockPos blockpos = context.f_197355_().m_151394_(-3);
        return JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)true);
    }
}

