/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.utils.ERUtils;
import com.teamremastered.endrem.world.structures.EndCastlePieces;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import org.jetbrains.annotations.NotNull;

public class EndCastle
extends StructureFeature<NoneFeatureConfiguration> {
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.f_20513_, 20, 50, 55), (Object)new CustomMonsterSpawn(EntityType.f_20493_, 9, 45, 50), (Object)new CustomMonsterSpawn(EntityType.f_20568_, 9, 15, 25), (Object)new CustomMonsterSpawn(EntityType.f_20459_, 3, 10, 15));

    public EndCastle(Codec<NoneFeatureConfiguration> codec) {
        super(codec, PieceGeneratorSupplier.m_197349_((Predicate)PieceGeneratorSupplier.m_197345_((Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG), EndCastle::generatePieces), EndCastle::afterPlace);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    private static boolean isFeatureChunk(PieceGenerator.Context<NoneFeatureConfiguration> context) {
        return ERUtils.getChunkDistanceFromSpawn(context.f_192705_()) >= ERConfig.END_CASTLE_SPAWN_DISTANCE.getRaw();
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.END_CASTLE.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(MobCategory.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    private static void generatePieces(StructurePiecesBuilder builder, PieceGenerator.Context<NoneFeatureConfiguration> context) {
        if (!EndCastle.isFeatureChunk(context)) {
            return;
        }
        Rotation rotation = Rotation.values()[context.f_192708_().nextInt(Rotation.values().length)];
        int x = context.f_192705_().f_45578_ << 4;
        int z = context.f_192705_().f_45579_ << 4;
        if (rotation == Rotation.CLOCKWISE_90) {
            x += 17;
            z += 43;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            x -= 43;
            z += 17;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            x -= 17;
            z -= 43;
        } else {
            x += 43;
            z -= 17;
        }
        int surfaceY = context.f_192703_().m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, context.f_192707_());
        BlockPos genPosition = new BlockPos(x, surfaceY, z);
        EndCastlePieces.addPieces(context.f_192704_(), genPosition, rotation, (StructurePieceAccessor)builder, (Random)context.f_192708_());
    }

    private static void afterPlace(WorldGenLevel genLevel, StructureFeatureManager featureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, PiecesContainer piecesContainer) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = genLevel.m_141937_();
        BoundingBox boundingbox = piecesContainer.m_192756_();
        int j = boundingbox.m_162396_();
        for (int k = boundingBox.m_162395_(); k <= boundingBox.m_162399_(); ++k) {
            block1: for (int l = boundingBox.m_162398_(); l <= boundingBox.m_162401_(); ++l) {
                blockpos$mutableblockpos.m_122178_(k, j, l);
                if (genLevel.m_46859_((BlockPos)blockpos$mutableblockpos) || !boundingbox.m_71051_((Vec3i)blockpos$mutableblockpos) || !piecesContainer.m_192751_((BlockPos)blockpos$mutableblockpos)) continue;
                for (int i1 = j - 1; i1 > i; --i1) {
                    blockpos$mutableblockpos.m_142448_(i1);
                    if (!genLevel.m_46859_((BlockPos)blockpos$mutableblockpos) && !genLevel.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76332_()) continue block1;
                    double randomBlock = Math.random();
                    if (randomBlock <= 0.05) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50069_.m_49966_(), 2);
                        continue;
                    }
                    if (randomBlock <= 0.1) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50652_.m_49966_(), 2);
                        continue;
                    }
                    if (randomBlock <= 0.2) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50334_.m_49966_(), 2);
                        continue;
                    }
                    if (randomBlock <= 0.3) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50222_.m_49966_(), 2);
                        continue;
                    }
                    if (randomBlock <= 0.4) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50224_.m_49966_(), 2);
                        continue;
                    }
                    if (randomBlock <= 0.5) {
                        genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50334_.m_49966_(), 2);
                        continue;
                    }
                    genLevel.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50387_.m_49966_(), 2);
                }
            }
        }
    }
}

