/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableMap;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;

public class EndCastlePieces {
    private static final int height = 0;
    private static final ResourceLocation BOTTOM_LEFT = new ResourceLocation("endrem", "end_castle/castle_bl");
    private static final ResourceLocation MID_LEFT = new ResourceLocation("endrem", "end_castle/castle_ml");
    private static final ResourceLocation TOP_LEFT = new ResourceLocation("endrem", "end_castle/castle_tl");
    private static final ResourceLocation BOTTOM_MID = new ResourceLocation("endrem", "end_castle/castle_bm");
    private static final ResourceLocation BOTTOM_RIGHT = new ResourceLocation("endrem", "end_castle/castle_br");
    public static final ResourceLocation MID_RIGHT = new ResourceLocation("endrem", "end_castle/castle_mr");
    public static final ResourceLocation TOP_RIGHT = new ResourceLocation("endrem", "end_castle/castle_tr");
    public static final ResourceLocation TOP_MID = new ResourceLocation("endrem", "end_castle/castle_tm");
    public static final ResourceLocation MID_MID = new ResourceLocation("endrem", "end_castle/castle_mm");
    private static final Map<ResourceLocation, BlockPos> OFFSET = ImmutableMap.of((Object)BOTTOM_LEFT, (Object)new BlockPos(20, 0, 24), (Object)MID_LEFT, (Object)new BlockPos(-25, 0, 24), (Object)TOP_LEFT, (Object)new BlockPos(-48, 0, 24), (Object)BOTTOM_RIGHT, (Object)new BlockPos(20, 0, -40), (Object)BOTTOM_MID, (Object)new BlockPos(41, 0, 0), (Object)MID_RIGHT, (Object)new BlockPos(-24, 0, -47), (Object)TOP_RIGHT, (Object)new BlockPos(-48, 0, -40), (Object)TOP_MID, (Object)new BlockPos(-48, 0, 0), (Object)MID_MID, (Object)new BlockPos(0, 0, 0));

    public static void addPieces(StructureManager structureManager, BlockPos blockPos, Rotation rotation, StructurePieceAccessor accessor, Random random) {
        for (Map.Entry<ResourceLocation, BlockPos> entry : OFFSET.entrySet()) {
            accessor.m_142679_((StructurePiece)new EndCastlePiece(structureManager, entry.getKey(), entry.getValue().m_7954_(rotation).m_142082_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), rotation));
        }
    }

    public static class EndCastlePiece
    extends TemplateStructurePiece {
        public EndCastlePiece(StructureManager structureManager, ResourceLocation resourceLocation, BlockPos blockPos, Rotation rotation) {
            super(ERStructures.EndCastlePieceType, 0, structureManager, resourceLocation, resourceLocation.toString(), EndCastlePiece.makeSettings(rotation), blockPos);
        }

        public EndCastlePiece(StructurePieceSerializationContext context, CompoundTag compoundTag) {
            super(ERStructures.EndCastlePieceType, compoundTag, context.f_192764_(), rl -> EndCastlePiece.makeSettings(Rotation.valueOf((String)compoundTag.m_128461_("Rot"))));
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE);
        }

        @ParametersAreNonnullByDefault
        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag tagCompound) {
            super.m_183620_(context, tagCompound);
            tagCompound.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        @ParametersAreNonnullByDefault
        protected void m_7756_(String chest, BlockPos pos, ServerLevelAccessor worldIn, Random rand, BoundingBox sbb) {
            ResourceLocation lootTable = new ResourceLocation("endrem", String.format("chests/%s", chest));
            worldIn.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)worldIn, (Random)rand, (BlockPos)pos.m_7495_(), (ResourceLocation)lootTable);
        }
    }
}

