/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.utils.ERUtils;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import com.teamremastered.endrem.world.structures.utils.CustomMonsterSpawn;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;
import org.jetbrains.annotations.NotNull;

public class EndGate
extends StructureFeature<JigsawConfiguration> {
    private static final ResourceLocation START_POOL = new ResourceLocation("endrem", "end_gate/start_pool");
    private static final List<CustomMonsterSpawn> MONSTER_SPAWN_LIST = ImmutableList.of((Object)new CustomMonsterSpawn(EntityType.f_20524_, 30, 30, 35), (Object)new CustomMonsterSpawn(EntityType.f_20501_, 20, 25, 30), (Object)new CustomMonsterSpawn(EntityType.f_20554_, 20, 25, 30), (Object)new CustomMonsterSpawn(EntityType.f_20495_, 10, 10, 15));

    public EndGate(Codec<JigsawConfiguration> codec) {
        super(codec, EndGate::createPiecesGenerator, PostPlacementProcessor.f_192427_);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.STRONGHOLDS;
    }

    private BlockPos getLocatedRoom(StructureStart<?> structureStart) {
        List structurePieces = structureStart.m_73602_();
        BoundingBox bbox = ((StructurePiece)structurePieces.get(Math.min(16, structurePieces.size()) - 1)).m_73547_();
        return new BlockPos(bbox.m_162395_(), bbox.m_162396_(), bbox.m_162398_());
    }

    @Nullable
    @ParametersAreNonnullByDefault
    public BlockPos m_67046_(LevelReader levelReader, StructureFeatureManager manager, BlockPos blockPos, int p_67050_, boolean p_67051_, long p_67052_, StructureFeatureConfiguration config) {
        int i = config.m_68171_();
        int j = SectionPos.m_123171_((int)blockPos.m_123341_());
        int k = SectionPos.m_123171_((int)blockPos.m_123343_());
        block0: for (int l = 0; l <= p_67050_; ++l) {
            for (int i1 = -l; i1 <= l; ++i1) {
                boolean flag = i1 == -l || i1 == l;
                for (int j1 = -l; j1 <= l; ++j1) {
                    int l1;
                    int k1;
                    ChunkPos chunkpos;
                    StructureCheckResult structurecheckresult;
                    boolean flag1;
                    boolean bl = flag1 = j1 == -l || j1 == l;
                    if (!flag && !flag1 || (structurecheckresult = manager.m_196670_(chunkpos = this.m_191122_(config, p_67052_, k1 = j + i * i1, l1 = k + i * j1), (StructureFeature)this, p_67051_)) == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!p_67051_ && structurecheckresult == StructureCheckResult.START_PRESENT) {
                        return this.getLocatedRoom(levelReader.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_).m_7253_((StructureFeature)this));
                    }
                    ChunkAccess chunkaccess = levelReader.m_46819_(chunkpos.f_45578_, chunkpos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart structurestart = manager.m_47297_(SectionPos.m_175562_((ChunkAccess)chunkaccess), (StructureFeature)this, (FeatureAccess)chunkaccess);
                    if (structurestart != null && structurestart.m_73603_()) {
                        if (p_67051_ && structurestart.m_73606_()) {
                            manager.m_196674_(structurestart);
                            return this.getLocatedRoom(structurestart);
                        }
                        if (!p_67051_) {
                            return this.getLocatedRoom(structurestart);
                        }
                    }
                    if (l == 0) break;
                }
                if (l == 0) continue block0;
            }
        }
        return null;
    }

    public static void setupStructureSpawns(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == ERStructures.END_GATE.get()) {
            for (CustomMonsterSpawn monsterSpawn : MONSTER_SPAWN_LIST) {
                event.addEntitySpawn(MobCategory.MONSTER, monsterSpawn.getIndividualMobSpawnInfo());
            }
        }
    }

    private static boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        return ERUtils.getChunkDistanceFromSpawn(context.f_197355_()) >= ERConfig.END_GATE_SPAWN_DISTANCE.getRaw();
    }

    @NotNull
    public static Optional<PieceGenerator<JigsawConfiguration>> createPiecesGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!EndGate.isFeatureChunk(context)) {
            return Optional.empty();
        }
        JigsawConfiguration newConfig = new JigsawConfiguration(() -> (StructureTemplatePool)context.f_197360_().m_175512_(Registry.f_122884_).m_7745_(START_POOL), ERConfig.END_GATE_SIZE.getRaw().intValue());
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        BlockPos blockpos = context.f_197355_().m_151394_(0).m_175288_(ERConfig.END_GATE_HEIGHT.getRaw().intValue());
        return JigsawPlacement.m_197210_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
    }
}

