/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.world.structures.AncientWitchHut;
import com.teamremastered.endrem.world.structures.EndCastle;
import com.teamremastered.endrem.world.structures.EndCastlePieces;
import com.teamremastered.endrem.world.structures.EndGate;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ERStructures {
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"endrem");
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> END_GATE = ERStructures.registerStructure("end_gate", () -> new EndGate((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> ANCIENT_WITCH_HUT = ERStructures.registerStructure("ancient_witch_hut", () -> new AncientWitchHut((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<StructureFeature<NoneFeatureConfiguration>> END_CASTLE = ERStructures.registerStructure("end_castle", () -> new EndCastle((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
    public static StructurePieceType EndCastlePieceType = EndCastlePieces.EndCastlePiece::new;

    private static <T extends StructureFeature<?>> RegistryObject<T> registerStructure(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        ERStructures.setupMapSpacingAndLand((StructureFeature)END_CASTLE.get(), new StructureFeatureConfiguration(ERConfig.END_CASTLE_DISTANCE.getRaw().intValue(), ERConfig.END_CASTLE_DISTANCE.getRaw() - 30, 487192276), ERConfig.END_CASTLE_TERRAFORMING.getRaw());
        ERStructures.setupMapSpacingAndLand((StructureFeature)END_GATE.get(), new StructureFeatureConfiguration(ERConfig.END_GATE_DISTANCE.getRaw().intValue(), ERConfig.END_GATE_DISTANCE.getRaw() - 30, 959834864), false);
        ERStructures.setupMapSpacingAndLand((StructureFeature)ANCIENT_WITCH_HUT.get(), new StructureFeatureConfiguration(ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw().intValue(), ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw() - 5, 324897233), false);
    }

    public static <F extends StructureFeature<?>> void setupMapSpacingAndLand(F structure, StructureFeatureConfiguration structureFeatureConfiguration, boolean transformSurroundingLand) {
        StructureFeature.f_67012_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add(structure).build();
        }
        StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put(structure, (Object)structureFeatureConfiguration).build();
    }

    static void registerStructurePiece(StructurePieceType structurePiece, ResourceLocation rl) {
        Registry.m_122965_((Registry)Registry.f_122843_, (ResourceLocation)rl, (Object)structurePiece);
    }

    public static void registerAllPieces() {
        ERStructures.registerStructurePiece(EndCastlePieceType, new ResourceLocation("endrem", "ec"));
    }
}

