/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.world.structures.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import com.teamremastered.endrem.EndRemastered;
import com.teamremastered.endrem.config.ERConfig;
import com.teamremastered.endrem.world.structures.AncientWitchHut;
import com.teamremastered.endrem.world.structures.EndCastle;
import com.teamremastered.endrem.world.structures.EndGate;
import com.teamremastered.endrem.world.structures.config.ERConfiguredStructures;
import com.teamremastered.endrem.world.structures.config.ERStructures;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class StructureGenerator {
    private static Method GETCODEC_METHOD;

    public static void init() {
        ERStructures.STRUCTURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, StructureGenerator::addDimensionalSpacing);
        if (!ERConfig.MONSTER_DIFFICULTY.getRaw().equals("peaceful")) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, EndGate::setupStructureSpawns);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, EndCastle::setupStructureSpawns);
            MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, AncientWitchHut::setupStructureSpawns);
        }
    }

    public static void setup() {
        ERStructures.setupStructures();
        ERStructures.registerAllPieces();
        ERConfiguredStructures.registerConfiguredStructures();
        ERStructures.setupStructures();
        ERConfiguredStructures.registerConfiguredStructures();
    }

    public static void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && ERConfig.WHITELISTED_DIMENSIONS.getList().contains(serverLevel.m_46472_().toString())) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap ERStructureToMultiMap = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                String biomeName = ((ResourceKey)biomeEntry.getKey()).m_135782_().toString();
                String biomeCategoryName = ((Biome)biomeEntry.getValue()).m_47567_().m_47645_();
                if (ERConfig.END_CASTLE_WHITELISTED_BIOME_CATEGORIES.getList().contains(biomeCategoryName) && !ERConfig.END_CASTLE_BLACKLISTED_BIOMES.getList().contains(biomeName) && ERConfig.END_CASTLE_DISTANCE.getRaw() > 0) {
                    StructureGenerator.associateBiomeToConfiguredStructure(ERStructureToMultiMap, ERConfiguredStructures.CONFIGURED_END_CASTLE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
                }
                if (ERConfig.END_GATE_WHITELISTED_BIOME_CATEGORIES.getList().contains(biomeCategoryName) && !ERConfig.END_GATE_BLACKLISTED_BIOMES.getList().contains(biomeName) && ERConfig.END_GATE_DISTANCE.getRaw() > 0) {
                    StructureGenerator.associateBiomeToConfiguredStructure(ERStructureToMultiMap, ERConfiguredStructures.CONFIGURED_END_GATE, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
                }
                if (!((Biome)biomeEntry.getValue()).m_47567_().equals((Object)Biome.BiomeCategory.SWAMP) || ERConfig.ANCIENT_WITCH_HUT_DISTANCE.getRaw() <= 0) continue;
                StructureGenerator.associateBiomeToConfiguredStructure(ERStructureToMultiMap, ERConfiguredStructures.CONFIGURED_ANCIENT_WITCH_HUT, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !ERStructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            ERStructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                EndRemastered.LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)ERStructures.END_CASTLE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ERStructures.END_CASTLE.get()));
            tempMap.putIfAbsent((StructureFeature)ERStructures.END_GATE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ERStructures.END_GATE.get()));
            tempMap.putIfAbsent((StructureFeature)ERStructures.ANCIENT_WITCH_HUT.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)ERStructures.ANCIENT_WITCH_HUT.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> ERStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        ERStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = ERStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            EndRemastered.LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

