/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.core;

import com.lothrazar.library.util.LevelWorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LivingTileCache {
    private final Map<String, Set<BlockPos>> alive;
    private final String name;
    public static boolean debug = false;
    private static final Logger LOGGER = LogManager.getLogger();

    public LivingTileCache(String n) {
        this.name = n;
        this.alive = new HashMap<String, Set<BlockPos>>();
    }

    private boolean add(String key, BlockPos pos) {
        if (!this.alive.containsKey(key)) {
            this.alive.put(key, new HashSet());
        }
        return this.alive.get(key).add(pos);
    }

    private boolean remove(String key, BlockPos pos) {
        if (this.alive.containsKey(key)) {
            return this.alive.get(key).remove(pos);
        }
        return false;
    }

    public void unload(Level level, BlockPos pos) {
        String key;
        boolean removed;
        if (!level.f_46443_ && (removed = this.remove(key = LevelWorldUtil.dimensionToString(level), pos)) && debug) {
            LOGGER.info("[" + this.name + "] removed: " + key + pos + " size " + this.alive.get(key).size());
        }
    }

    public void load(Level level, BlockPos pos) {
        if (!level.f_46443_) {
            String key = LevelWorldUtil.dimensionToString(level);
            boolean added = this.add(key, pos);
            if (added) {
                if (debug) {
                    LOGGER.info("[" + this.name + "] added: " + key + pos + " size " + this.alive.get(key).size());
                }
            } else if (debug) {
                LOGGER.info("[" + this.name + "] ping : " + key + pos + " size " + this.alive.get(key).size());
            }
        }
    }

    public boolean hasCollision(Level level, BlockPos mobPos, int radius, int height) {
        Iterator<BlockPos> iterator;
        String key = LevelWorldUtil.dimensionToString(level);
        if (this.alive.containsKey(key) && (iterator = this.alive.get(key).iterator()).hasNext()) {
            BlockPos candle = iterator.next();
            return LevelWorldUtil.withinArea(mobPos, radius, height, candle);
        }
        return false;
    }

    public int size() {
        return this.alive.size();
    }
}

