/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.recipe.ingredient;

import com.google.gson.JsonObject;
import com.lothrazar.library.FutureLibMod;

public class EnergyIngredient {
    private static final String KEY_ENERGY = "energy";
    private static final int TICKS_DEFAULT = 60;
    private static final int RFPT_DEFAULT = 80;
    private int rfPertick;
    private int ticks;

    public EnergyIngredient(int rf, int ticks) {
        this.setRf(rf);
        this.setTicks(ticks);
    }

    public EnergyIngredient(JsonObject recipeJson) {
        this.parseData(recipeJson);
    }

    private void parseData(JsonObject recipeJson) {
        if (!recipeJson.has(KEY_ENERGY)) {
            FutureLibMod.LOGGER.error("  Missing JSON 'energy', setting default values" + recipeJson);
            this.setRf(80);
            this.setTicks(60);
        } else if (recipeJson.get(KEY_ENERGY).isJsonObject()) {
            JsonObject energyJson = recipeJson.get(KEY_ENERGY).getAsJsonObject();
            this.setRf(energyJson.get("rfpertick").getAsInt());
            this.setTicks(energyJson.get("ticks").getAsInt());
        }
    }

    private void setTicks(int ticks) {
        this.ticks = Math.max(1, ticks);
    }

    private void setRf(int rf) {
        this.rfPertick = Math.max(0, rf);
    }

    public int getEnergyTotal() {
        return this.rfPertick * this.ticks;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getRfPertick() {
        return this.rfPertick;
    }
}

