/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.backend.gl.GlPrimitive;
import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.MappedGlBuffer;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.ElementBuffer;
import com.jozufozu.flywheel.core.model.Model;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL31;

public class IndexedModel
implements BufferedModel {
    protected final VertexType type;
    protected final Model model;
    protected final GlPrimitive primitiveMode;
    protected ElementBuffer ebo;
    protected GlBuffer vbo;
    protected boolean deleted;

    public IndexedModel(Model model) {
        this(model, model.getType());
    }

    public IndexedModel(Model model, VertexType type) {
        this.type = type;
        this.model = model;
        this.primitiveMode = GlPrimitive.TRIANGLES;
        this.vbo = new MappedGlBuffer(GlBufferType.ARRAY_BUFFER);
        this.vbo.bind();
        this.vbo.ensureCapacity(model.size());
        try (MappedBuffer buffer = this.vbo.getBuffer();){
            type.createWriter(buffer.unwrap()).writeVertexList(model.getReader());
        }
        catch (Exception e) {
            Flywheel.LOGGER.error(String.format("Error uploading model '%s':", model.name()), (Throwable)e);
        }
        this.vbo.unbind();
        this.ebo = model.createEBO();
    }

    @Override
    public void setupState(GlVertexArray vao) {
        this.vbo.bind();
        vao.enableArrays(this.getAttributeCount());
        vao.bindAttributes(0, this.getType().getLayout());
        this.ebo.bind();
    }

    @Override
    public void drawCall() {
        GL20.glDrawElements((int)this.primitiveMode.glEnum, (int)this.ebo.getElementCount(), (int)this.ebo.getEboIndexType().f_166923_, (long)0L);
    }

    @Override
    public void drawInstances(int instanceCount) {
        if (!this.valid()) {
            return;
        }
        GL31.glDrawElementsInstanced((int)this.primitiveMode.glEnum, (int)this.ebo.getElementCount(), (int)this.ebo.getEboIndexType().f_166923_, (long)0L, (int)instanceCount);
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public VertexType getType() {
        return this.type;
    }

    @Override
    public int getVertexCount() {
        return this.model.vertexCount();
    }

    @Override
    public void delete() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        this.vbo.delete();
    }
}

