/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.gui.GuiScreenHelper;
import mezz.jei.common.gui.PageNavigation;
import mezz.jei.common.gui.elements.DrawableNineSliceTexture;
import mezz.jei.common.gui.overlay.IIngredientGridSource;
import mezz.jei.common.gui.overlay.IngredientGrid;
import mezz.jei.common.gui.overlay.options.NavigationVisibility;
import mezz.jei.common.gui.recipes.RecipesGui;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IPaged;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.common.input.handlers.LimitedAreaInputHandler;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.util.CheatUtil;
import mezz.jei.common.util.CommandUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class IngredientGridWithNavigation
implements IRecipeFocusSource {
    private static final int NAVIGATION_HEIGHT = 20;
    private static final int BORDER_PADDING = 5;
    private static final int INNER_PADDING = 2;
    private int firstItemIndex = 0;
    private final IngredientGridPaged pageDelegate;
    private final PageNavigation navigation;
    private final GuiScreenHelper guiScreenHelper;
    private final IIngredientGridConfig gridConfig;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IngredientGrid ingredientGrid;
    private final IIngredientGridSource ingredientSource;
    private final DrawableNineSliceTexture background;
    private final DrawableNineSliceTexture slotBackground;
    private final CommandUtil commandUtil;
    private ImmutableRect2i backgroundArea = ImmutableRect2i.EMPTY;
    private ImmutableRect2i slotBackgroundArea = ImmutableRect2i.EMPTY;

    public IngredientGridWithNavigation(IIngredientGridSource ingredientSource, GuiScreenHelper guiScreenHelper, IngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection, IIngredientGridConfig gridConfig, DrawableNineSliceTexture background, DrawableNineSliceTexture slotBackground, Textures textures) {
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.ingredientGrid = ingredientGrid;
        this.ingredientSource = ingredientSource;
        this.guiScreenHelper = guiScreenHelper;
        this.gridConfig = gridConfig;
        this.pageDelegate = new IngredientGridPaged();
        this.navigation = new PageNavigation(this.pageDelegate, false, textures);
        this.background = background;
        this.slotBackground = slotBackground;
        this.commandUtil = new CommandUtil(clientConfig, serverConnection);
        this.ingredientSource.addSourceListChangedListener(() -> this.updateLayout(true));
    }

    public void updateLayout(boolean resetToFirstPage) {
        List<ITypedIngredient<?>> ingredientList;
        if (resetToFirstPage) {
            this.firstItemIndex = 0;
        }
        if (this.firstItemIndex >= (ingredientList = this.ingredientSource.getIngredientList()).size()) {
            this.firstItemIndex = 0;
        }
        this.ingredientGrid.set(this.firstItemIndex, ingredientList);
        this.navigation.updatePageNumber();
    }

    private static ImmutableRect2i cropToAvoidNavigationArea(ImmutableRect2i availableArea, Set<ImmutableRect2i> guiExclusionAreas, int maxWidth, int maxHeight) {
        if (guiExclusionAreas.isEmpty()) {
            return availableArea;
        }
        ImmutableRect2i estimatedNavigationArea = availableArea.keepTop(22);
        List<ImmutableRect2i> intersectsNavigationArea = guiExclusionAreas.stream().filter(rectangle2d -> MathUtil.intersects(rectangle2d, estimatedNavigationArea)).toList();
        if (intersectsNavigationArea.isEmpty()) {
            return availableArea;
        }
        return MathUtil.cropToAvoidIntersection(intersectsNavigationArea, availableArea, maxWidth, maxHeight);
    }

    private boolean updateGridBounds(ImmutableRect2i availableArea, Set<ImmutableRect2i> guiExclusionAreas, boolean navigationEnabled) {
        ImmutableRect2i gridArea = navigationEnabled ? IngredientGridWithNavigation.cropToAvoidNavigationArea(availableArea, guiExclusionAreas, this.ingredientGrid.maxWidth(), this.ingredientGrid.maxHeight()).cropTop(22).insetBy(2) : availableArea.insetBy(2);
        return this.ingredientGrid.updateBounds(gridArea, guiExclusionAreas);
    }

    public boolean updateBounds(ImmutableRect2i availableArea, Set<ImmutableRect2i> guiExclusionAreas) {
        ImmutableRect2i availableGridArea = this.gridConfig.drawBackground() ? availableArea.insetBy(7) : availableArea;
        boolean navigationEnabled = switch (this.gridConfig.getButtonNavigationVisibility()) {
            default -> throw new IncompatibleClassChangeError();
            case NavigationVisibility.ENABLED -> true;
            case NavigationVisibility.DISABLED -> false;
            case NavigationVisibility.AUTO_HIDE -> this.updateGridBounds(availableGridArea, guiExclusionAreas, false) && this.pageDelegate.getPageCount() > 1;
        };
        boolean gridHasRoom = this.updateGridBounds(availableGridArea, guiExclusionAreas, navigationEnabled);
        if (!gridHasRoom) {
            return false;
        }
        this.slotBackgroundArea = this.ingredientGrid.getArea();
        if (this.gridConfig.drawBackground()) {
            this.slotBackgroundArea = this.slotBackgroundArea.expandBy(2);
        }
        ImmutableRect2i navigationArea = ImmutableRect2i.EMPTY;
        if (navigationEnabled) {
            navigationArea = this.slotBackgroundArea.keepTop(20).moveUp(22);
        }
        this.navigation.updateBounds(navigationArea);
        this.backgroundArea = MathUtil.union(this.slotBackgroundArea, navigationArea);
        if (this.gridConfig.drawBackground()) {
            this.backgroundArea = this.backgroundArea.expandBy(5);
        }
        return true;
    }

    public ImmutableRect2i getBackgroundArea() {
        return this.backgroundArea;
    }

    public void draw(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        if (this.gridConfig.drawBackground()) {
            this.background.draw(poseStack, this.backgroundArea);
            this.slotBackground.draw(poseStack, this.slotBackgroundArea);
        }
        this.ingredientGrid.draw(minecraft, poseStack, mouseX, mouseY);
        this.navigation.draw(minecraft, poseStack, mouseX, mouseY, partialTicks);
    }

    public void drawTooltips(Minecraft minecraft, PoseStack poseStack, int mouseX, int mouseY) {
        this.ingredientGrid.drawTooltips(minecraft, poseStack, mouseX, mouseY);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.backgroundArea.contains(mouseX, mouseY) && !this.guiScreenHelper.isInGuiExclusionArea(mouseX, mouseY);
    }

    public IUserInputHandler createInputHandler() {
        return new CombinedInputHandler(new UserInputHandler(this.pageDelegate, this.ingredientGrid, this.worldConfig, this.clientConfig, this.commandUtil, this::isMouseOver), this.ingredientGrid.getInputHandler(), this.navigation.createInputHandler());
    }

    @Override
    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(double mouseX, double mouseY) {
        return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY);
    }

    public <T> Stream<T> getVisibleIngredients(IIngredientType<T> ingredientType) {
        return this.ingredientGrid.getVisibleIngredients(ingredientType);
    }

    public boolean isEmpty() {
        return this.ingredientSource.getIngredientList().isEmpty();
    }

    private class IngredientGridPaged
    implements IPaged {
        private IngredientGridPaged() {
        }

        @Override
        public boolean nextPage() {
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList().size();
            if (itemsCount > 0) {
                IngredientGridWithNavigation.this.firstItemIndex += IngredientGridWithNavigation.this.ingredientGrid.size();
                if (IngredientGridWithNavigation.this.firstItemIndex >= itemsCount) {
                    IngredientGridWithNavigation.this.firstItemIndex = 0;
                }
                IngredientGridWithNavigation.this.updateLayout(false);
                return true;
            }
            IngredientGridWithNavigation.this.firstItemIndex = 0;
            IngredientGridWithNavigation.this.updateLayout(false);
            return false;
        }

        @Override
        public boolean previousPage() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (itemsPerPage == 0) {
                IngredientGridWithNavigation.this.firstItemIndex = 0;
                IngredientGridWithNavigation.this.updateLayout(false);
                return false;
            }
            int itemsCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList().size();
            int pageNum = IngredientGridWithNavigation.this.firstItemIndex / itemsPerPage;
            pageNum = pageNum == 0 ? itemsCount / itemsPerPage : --pageNum;
            IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * pageNum;
            if (IngredientGridWithNavigation.this.firstItemIndex > 0 && IngredientGridWithNavigation.this.firstItemIndex == itemsCount) {
                IngredientGridWithNavigation.this.firstItemIndex = itemsPerPage * --pageNum;
            }
            IngredientGridWithNavigation.this.updateLayout(false);
            return true;
        }

        @Override
        public boolean hasNext() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList().size() > itemsPerPage;
        }

        @Override
        public boolean hasPrevious() {
            int itemsPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            return itemsPerPage > 0 && IngredientGridWithNavigation.this.ingredientSource.getIngredientList().size() > itemsPerPage;
        }

        @Override
        public int getPageCount() {
            int itemCount = IngredientGridWithNavigation.this.ingredientSource.getIngredientList().size();
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 1;
            }
            int pageCount = MathUtil.divideCeil(itemCount, stacksPerPage);
            pageCount = Math.max(1, pageCount);
            return pageCount;
        }

        @Override
        public int getPageNumber() {
            int stacksPerPage = IngredientGridWithNavigation.this.ingredientGrid.size();
            if (stacksPerPage == 0) {
                return 0;
            }
            return IngredientGridWithNavigation.this.firstItemIndex / stacksPerPage;
        }
    }

    private static class UserInputHandler
    implements IUserInputHandler {
        private final IngredientGridPaged paged;
        private final IRecipeFocusSource focusSource;
        private final IWorldConfig worldConfig;
        private final IClientConfig clientConfig;
        private final UserInput.MouseOverable mouseOverable;
        private final CommandUtil commandUtil;

        private UserInputHandler(IngredientGridPaged paged, IRecipeFocusSource focusSource, IWorldConfig worldConfig, IClientConfig clientConfig, CommandUtil commandUtil, UserInput.MouseOverable mouseOverable) {
            this.paged = paged;
            this.focusSource = focusSource;
            this.worldConfig = worldConfig;
            this.clientConfig = clientConfig;
            this.mouseOverable = mouseOverable;
            this.commandUtil = commandUtil;
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
            if (!this.mouseOverable.isMouseOver(mouseX, mouseY)) {
                return Optional.empty();
            }
            if (scrollDelta < 0.0) {
                this.paged.nextPage();
                return Optional.of(this);
            }
            if (scrollDelta > 0.0) {
                this.paged.previousPage();
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            if (input.is(keyBindings.getNextPage())) {
                this.paged.nextPage();
                return Optional.of(this);
            }
            if (input.is(keyBindings.getPreviousPage())) {
                this.paged.previousPage();
                return Optional.of(this);
            }
            return this.checkHotbarKeys(screen, input);
        }

        protected Optional<IUserInputHandler> checkHotbarKeys(Screen screen, UserInput input) {
            double mouseY;
            if (!this.clientConfig.isCheatToHotbarUsingHotkeysEnabled() || !this.worldConfig.isCheatItemsEnabled() || screen instanceof RecipesGui) {
                return Optional.empty();
            }
            double mouseX = input.getMouseX();
            if (!this.mouseOverable.isMouseOver(mouseX, mouseY = input.getMouseY())) {
                return Optional.empty();
            }
            Minecraft minecraft = Minecraft.m_91087_();
            Options gameSettings = minecraft.f_91066_;
            int hotbarSlot = UserInputHandler.getHotbarSlotForInput(input, gameSettings);
            if (hotbarSlot < 0) {
                return Optional.empty();
            }
            return this.focusSource.getIngredientUnderMouse(mouseX, mouseY).flatMap(clickedIngredient -> {
                ItemStack cheatItemStack = CheatUtil.getCheatItemStack(clickedIngredient);
                if (!cheatItemStack.m_41619_()) {
                    this.commandUtil.setHotbarStack(cheatItemStack, hotbarSlot);
                    ImmutableRect2i area = clickedIngredient.getArea();
                    return Stream.of(LimitedAreaInputHandler.create(this, area));
                }
                return Stream.empty();
            }).findFirst();
        }

        private static int getHotbarSlotForInput(UserInput input, Options gameSettings) {
            for (int hotbarSlot = 0; hotbarSlot < gameSettings.f_92056_.length; ++hotbarSlot) {
                KeyMapping keyHotbarSlot = gameSettings.f_92056_[hotbarSlot];
                if (!input.is(keyHotbarSlot)) continue;
                return hotbarSlot;
            }
            return -1;
        }
    }
}

