/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.config.sorting.RecipeCategorySortingConfig;
import mezz.jei.common.ingredients.IIngredientSupplier;
import mezz.jei.common.ingredients.RegisteredIngredients;
import mezz.jei.common.recipes.InternalRecipeManagerPlugin;
import mezz.jei.common.recipes.PluginManager;
import mezz.jei.common.recipes.RecipeCatalystBuilder;
import mezz.jei.common.recipes.collect.RecipeMap;
import mezz.jei.common.recipes.collect.RecipeTypeData;
import mezz.jei.common.recipes.collect.RecipeTypeDataMap;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.IngredientSupplierHelper;
import mezz.jei.common.util.RecipeErrorUtil;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeManagerInternal {
    private static final Logger LOGGER = LogManager.getLogger();
    private final @Unmodifiable List<IRecipeCategory<?>> recipeCategories;
    private final IIngredientVisibility ingredientVisibility;
    private final RegisteredIngredients registeredIngredients;
    private final RecipeTypeDataMap recipeTypeDataMap;
    private final Comparator<IRecipeCategory<?>> recipeCategoryComparator;
    private final EnumMap<RecipeIngredientRole, RecipeMap> recipeMaps;
    private final PluginManager pluginManager;
    private final Set<RecipeType<?>> hiddenRecipeTypes = new HashSet();
    @Nullable
    private @Unmodifiable List<IRecipeCategory<?>> recipeCategoriesVisibleCache = null;

    public RecipeManagerInternal(List<IRecipeCategory<?>> recipeCategories, ImmutableListMultimap<ResourceLocation, ITypedIngredient<?>> recipeCatalysts, RegisteredIngredients registeredIngredients, List<IRecipeManagerPlugin> plugins, RecipeCategorySortingConfig recipeCategorySortingConfig, IIngredientVisibility ingredientVisibility) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        this.registeredIngredients = registeredIngredients;
        this.ingredientVisibility = ingredientVisibility;
        List<RecipeType> recipeTypes = recipeCategories.stream().map(IRecipeCategory::getRecipeType).toList();
        Comparator<RecipeType<?>> recipeTypeComparator = recipeCategorySortingConfig.getComparator(recipeTypes);
        this.recipeMaps = new EnumMap(RecipeIngredientRole.class);
        for (RecipeIngredientRole role : RecipeIngredientRole.values()) {
            RecipeMap recipeMap = new RecipeMap(recipeTypeComparator, registeredIngredients, role);
            this.recipeMaps.put(role, recipeMap);
        }
        this.recipeCategoryComparator = Comparator.comparing(IRecipeCategory::getRecipeType, recipeTypeComparator);
        this.recipeCategories = recipeCategories.stream().sorted(this.recipeCategoryComparator).toList();
        RecipeCatalystBuilder recipeCatalystBuilder = new RecipeCatalystBuilder(registeredIngredients, this.recipeMaps.get((Object)RecipeIngredientRole.CATALYST));
        for (IRecipeCategory<?> recipeCategory : recipeCategories) {
            ResourceLocation recipeCategoryUid = recipeCategory.getRecipeType().getUid();
            if (!recipeCatalysts.containsKey((Object)recipeCategoryUid)) continue;
            ImmutableList catalysts = recipeCatalysts.get((Object)recipeCategoryUid);
            recipeCatalystBuilder.addCategoryCatalysts(recipeCategory, (List<ITypedIngredient<?>>)catalysts);
        }
        ImmutableListMultimap<IRecipeCategory<?>, ITypedIngredient<?>> recipeCategoryCatalystsMap = recipeCatalystBuilder.buildRecipeCategoryCatalysts();
        this.recipeTypeDataMap = new RecipeTypeDataMap(recipeCategories, recipeCategoryCatalystsMap);
        InternalRecipeManagerPlugin internalRecipeManagerPlugin = new InternalRecipeManagerPlugin(registeredIngredients, this.recipeTypeDataMap, this.recipeMaps);
        this.pluginManager = new PluginManager(internalRecipeManagerPlugin, plugins);
    }

    public <T> void addRecipes(RecipeType<T> recipeType, List<T> recipes) {
        LOGGER.debug("Adding recipes: " + recipeType.getUid());
        RecipeTypeData<List<T>> recipeTypeData = this.recipeTypeDataMap.get(recipes, recipeType);
        this.addRecipes(recipeTypeData, recipes);
    }

    private <T> void addRecipes(RecipeTypeData<T> recipeTypeData, Collection<T> recipes) {
        IRecipeCategory recipeCategory = recipeTypeData.getRecipeCategory();
        Set hiddenRecipes = recipeTypeData.getHiddenRecipes();
        List<Object> addedRecipes = recipes.stream().filter(recipe -> {
            if (hiddenRecipes.contains(recipe) || !recipeCategory.isHandled(recipe)) {
                return false;
            }
            IIngredientSupplier ingredientSupplier = IngredientSupplierHelper.getIngredientSupplier(recipe, recipeCategory, this.registeredIngredients, this.ingredientVisibility);
            if (ingredientSupplier == null) {
                return false;
            }
            return this.addRecipe(recipeCategory, recipe, ingredientSupplier);
        }).toList();
        if (!addedRecipes.isEmpty()) {
            recipeTypeData.addRecipes(addedRecipes);
            this.recipeCategoriesVisibleCache = null;
        }
    }

    private <T> boolean addRecipe(IRecipeCategory<T> recipeCategory, T recipe, IIngredientSupplier ingredientSupplier) {
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        try {
            for (RecipeMap recipeMap : this.recipeMaps.values()) {
                recipeMap.addRecipe(recipeType, recipe, ingredientSupplier);
            }
            return true;
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, recipeCategory);
            LOGGER.error("Found a broken recipe, failed to addRecipe: {}\n", (Object)recipeInfo, (Object)e);
            return false;
        }
    }

    public boolean isCategoryHidden(IRecipeCategory<?> recipeCategory, IFocusGroup focuses) {
        RecipeType<?> recipeType = recipeCategory.getRecipeType();
        if (this.hiddenRecipeTypes.contains(recipeType)) {
            return true;
        }
        if (this.getRecipeCatalystStream(recipeType, true).findAny().isPresent() && this.getRecipeCatalystStream(recipeType, false).findAny().isEmpty()) {
            return true;
        }
        Stream<?> visibleRecipes = this.getRecipesStream(recipeType, focuses, false);
        return visibleRecipes.findAny().isEmpty();
    }

    public Stream<IRecipeCategory<?>> getRecipeCategoriesForTypes(Collection<RecipeType<?>> recipeTypes, IFocusGroup focuses, boolean includeHidden) {
        List<IRecipeCategory<?>> recipeCategories = recipeTypes.stream().map(this.recipeTypeDataMap::get).map(RecipeTypeData::getRecipeCategory).toList();
        return this.getRecipeCategoriesCached(recipeCategories, focuses, includeHidden);
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesCached(Collection<IRecipeCategory<?>> recipeCategories, IFocusGroup focuses, boolean includeHidden) {
        if (recipeCategories.isEmpty() && focuses.isEmpty() && !includeHidden) {
            if (this.recipeCategoriesVisibleCache == null) {
                this.recipeCategoriesVisibleCache = this.getRecipeCategoriesUncached(recipeCategories, focuses, includeHidden).toList();
            }
            return this.recipeCategoriesVisibleCache.stream();
        }
        return this.getRecipeCategoriesUncached(recipeCategories, focuses, includeHidden);
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesUncached(Collection<IRecipeCategory<?>> recipeCategories, IFocusGroup focuses, boolean includeHidden) {
        Stream<Object> categoryStream;
        if (focuses.isEmpty()) {
            categoryStream = recipeCategories.isEmpty() ? this.recipeCategories.stream() : recipeCategories.stream().distinct();
        } else {
            categoryStream = this.pluginManager.getRecipeTypes(focuses).map(this.recipeTypeDataMap::get).map(RecipeTypeData::getRecipeCategory);
            if (!recipeCategories.isEmpty()) {
                categoryStream = categoryStream.filter(recipeCategories::contains);
            }
        }
        if (!includeHidden) {
            categoryStream = categoryStream.filter(c -> !this.isCategoryHidden((IRecipeCategory<?>)c, focuses));
        }
        return categoryStream.sorted(this.recipeCategoryComparator);
    }

    public <T> Stream<T> getRecipesStream(RecipeType<T> recipeType, IFocusGroup focuses, boolean includeHidden) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        return this.pluginManager.getRecipes(recipeTypeData, focuses, includeHidden);
    }

    public <T> Stream<ITypedIngredient<?>> getRecipeCatalystStream(RecipeType<T> recipeType, boolean includeHidden) {
        RecipeTypeData<T> recipeTypeData = this.recipeTypeDataMap.get(recipeType);
        List<ITypedIngredient<?>> catalysts = recipeTypeData.getRecipeCategoryCatalysts();
        if (includeHidden) {
            return catalysts.stream();
        }
        return catalysts.stream().filter(this.ingredientVisibility::isIngredientVisible);
    }

    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        RecipeTypeData<Collection<T>> recipeTypeData = this.recipeTypeDataMap.get(recipes, recipeType);
        Set<Collection<T>> hiddenRecipes = recipeTypeData.getHiddenRecipes();
        hiddenRecipes.addAll(recipes);
        this.recipeCategoriesVisibleCache = null;
    }

    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> recipes) {
        RecipeTypeData<Collection<T>> recipeTypeData = this.recipeTypeDataMap.get(recipes, recipeType);
        Set<Collection<T>> hiddenRecipes = recipeTypeData.getHiddenRecipes();
        hiddenRecipes.removeAll(recipes);
        this.recipeCategoriesVisibleCache = null;
    }

    public void hideRecipeCategory(RecipeType<?> recipeType) {
        this.hiddenRecipeTypes.add(recipeType);
        this.recipeCategoriesVisibleCache = null;
    }

    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        this.recipeTypeDataMap.validate(recipeType);
        this.hiddenRecipeTypes.remove(recipeType);
        this.recipeCategoriesVisibleCache = null;
    }

    public Optional<RecipeType<?>> getRecipeType(ResourceLocation recipeUid) {
        return this.recipeTypeDataMap.getType(recipeUid);
    }
}

