/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.InputType;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.input.handlers.CombinedInputHandler;
import mezz.jei.core.config.IClientConfig;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserInputRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IClientConfig config;
    private final CombinedInputHandler combinedInputHandler;
    private final Map<InputConstants.Key, IUserInputHandler> pending = new HashMap<InputConstants.Key, IUserInputHandler>();

    public UserInputRouter(IClientConfig config, IUserInputHandler ... inputHandlers) {
        this.config = config;
        this.combinedInputHandler = new CombinedInputHandler(inputHandlers);
    }

    public boolean handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        if (this.config.isDebugModeEnabled()) {
            LOGGER.debug("Received user input: {}", (Object)input);
        }
        return switch (input.getClickState()) {
            default -> throw new IncompatibleClassChangeError();
            case InputType.IMMEDIATE -> this.handleImmediateClick(screen, input, keyBindings);
            case InputType.SIMULATE -> this.handleSimulateClick(screen, input, keyBindings);
            case InputType.EXECUTE -> this.handleExecuteClick(screen, input, keyBindings);
        };
    }

    private boolean handleImmediateClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && this.config.isDebugModeEnabled()) {
            LOGGER.debug("Canceled previous user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            if (this.config.isDebugModeEnabled()) {
                LOGGER.debug("Immediate click handled by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleSimulateClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        IUserInputHandler oldClick = this.pending.remove(input.getKey());
        if (oldClick != null && this.config.isDebugModeEnabled()) {
            LOGGER.debug("Canceled pending user input: {}", (Object)oldClick);
        }
        return this.combinedInputHandler.handleUserInput(screen, input, keyBindings).map(callback -> {
            this.pending.put(input.getKey(), (IUserInputHandler)callback);
            if (this.config.isDebugModeEnabled()) {
                LOGGER.debug("Click successfully simulated by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    private boolean handleExecuteClick(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
        return Optional.ofNullable(this.pending.remove(input.getKey())).flatMap(inputHandler -> inputHandler.handleUserInput(screen, input, keyBindings)).map(callback -> {
            if (this.config.isDebugModeEnabled()) {
                LOGGER.debug("Click successfully executed by: {}\n{}", callback, (Object)input);
            }
            return true;
        }).orElse(false);
    }

    public void handleGuiChange() {
        LOGGER.debug("The GUI has changed, clearing all pending clicks");
        for (InputConstants.Key key : this.pending.keySet()) {
            this.combinedInputHandler.handleMouseClickedOut(key);
        }
        this.pending.clear();
    }

    public boolean handleMouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return this.combinedInputHandler.handleMouseScrolled(mouseX, mouseY, scrollDelta).map(callback -> {
            if (this.config.isDebugModeEnabled()) {
                LOGGER.debug("Scroll handled by: {}", callback);
            }
            return true;
        }).orElse(false);
    }
}

