/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.ingredients.IngredientSet;
import mezz.jei.common.platform.IPlatformIngredientHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrewingRecipeMakerCommon {
    private static final Logger LOGGER = LogManager.getLogger();

    public static Set<IJeiBrewingRecipe> getVanillaBrewingRecipes(IVanillaRecipeFactory recipeFactory, IIngredientManager ingredientManager, IVanillaPotionOutputSupplier vanillaOutputSupplier) {
        boolean foundNewPotions;
        HashSet<IJeiBrewingRecipe> recipes = new HashSet<IJeiBrewingRecipe>();
        IPlatformRegistry<Potion> potionRegistry = Services.PLATFORM.getRegistry(Registry.f_122905_);
        IngredientSet<ItemStack> knownPotions = BrewingRecipeMakerCommon.getBaseKnownPotions(ingredientManager, potionRegistry);
        List<ItemStack> potionReagents = ingredientManager.getAllItemStacks().stream().filter(BrewingRecipeMakerCommon::isIngredient).toList();
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = BrewingRecipeMakerCommon.getNewPotions(recipeFactory, potionRegistry, knownPotions, potionReagents, vanillaOutputSupplier, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
        return recipes;
    }

    private static boolean isIngredient(ItemStack itemStack) {
        try {
            return PotionBrewing.m_43506_((ItemStack)itemStack);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.error("Failed to check if item is a potion reagent {}.", (Object)itemStackInfo, (Object)e);
            return false;
        }
    }

    private static IngredientSet<ItemStack> getBaseKnownPotions(IIngredientManager ingredientManager, IPlatformRegistry<Potion> potionRegistry) {
        IPlatformIngredientHelper ingredientHelper = Services.PLATFORM.getIngredientHelper();
        List potionContainers = ingredientHelper.getPotionContainers().stream().flatMap(potionItem -> Arrays.stream(potionItem.m_43908_())).toList();
        IIngredientHelper itemStackHelper = ingredientManager.getIngredientHelper(VanillaTypes.ITEM_STACK);
        IngredientSet<ItemStack> knownPotions = IngredientSet.create(itemStackHelper, UidContext.Ingredient);
        potionRegistry.getValues().filter(potion -> potion != Potions.f_43598_).forEach(potion -> {
            for (ItemStack potionContainer : potionContainers) {
                ItemStack result = PotionUtils.m_43549_((ItemStack)potionContainer.m_41777_(), (Potion)potion);
                knownPotions.add(result);
            }
        });
        return knownPotions;
    }

    private static List<ItemStack> getNewPotions(IVanillaRecipeFactory recipeFactory, IPlatformRegistry<Potion> potionRegistry, Collection<ItemStack> knownPotions, List<ItemStack> potionReagents, IVanillaPotionOutputSupplier vanillaOutputSupplier, Collection<IJeiBrewingRecipe> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionReagent : potionReagents) {
                IJeiBrewingRecipe recipe;
                ResourceLocation outputId;
                Potion potionInputType;
                ResourceLocation inputId;
                Potion potionOutputType;
                ItemStack potionOutput = vanillaOutputSupplier.getOutput(potionInput.m_41777_(), potionReagent);
                if (potionOutput.m_41619_() || potionInput.m_41720_() == potionOutput.m_41720_() && ((potionOutputType = PotionUtils.m_43579_((ItemStack)potionOutput)) == Potions.f_43599_ || Objects.equals(inputId = potionRegistry.getRegistryName(potionInputType = PotionUtils.m_43579_((ItemStack)potionInput)), outputId = potionRegistry.getRegistryName(potionOutputType))) || recipes.contains(recipe = recipeFactory.createBrewingRecipe(List.of(potionReagent), potionInput.m_41777_(), potionOutput))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    @FunctionalInterface
    public static interface IVanillaPotionOutputSupplier {
        public ItemStack getOutput(ItemStack var1, ItemStack var2);
    }
}

