/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.runtime.IScreenHelper;
import mezz.jei.common.config.DebugConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.platform.IPlatformScreenHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.RectDebugger;
import mezz.jei.core.util.LimitedLogger;
import mezz.jei.gui.input.MouseUtil;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.overlay.bookmarks.BookmarkOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger missingBackgroundLogger = new LimitedLogger(LOGGER, Duration.ofHours(1L));
    private final IngredientListOverlay ingredientListOverlay;
    private final IScreenHelper screenHelper;
    private final BookmarkOverlay bookmarkOverlay;
    private boolean drawnOnBackground = false;

    public GuiEventHandler(IScreenHelper screenHelper, BookmarkOverlay bookmarkOverlay, IngredientListOverlay ingredientListOverlay) {
        this.screenHelper = screenHelper;
        this.bookmarkOverlay = bookmarkOverlay;
        this.ingredientListOverlay = ingredientListOverlay;
    }

    public void onGuiInit(Screen screen) {
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
        this.bookmarkOverlay.updateScreen(screen, guiExclusionAreas);
    }

    public void onGuiOpen(Screen screen) {
        this.ingredientListOverlay.updateScreen(screen, null);
        this.bookmarkOverlay.updateScreen(screen, null);
    }

    public void onDrawBackgroundPost(Screen screen, PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Set<ImmutableRect2i> guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).map(ImmutableRect2i::new).collect(Collectors.toUnmodifiableSet());
        this.ingredientListOverlay.updateScreen(screen, guiExclusionAreas);
        this.bookmarkOverlay.updateScreen(screen, guiExclusionAreas);
        this.drawnOnBackground = true;
        double mouseX = MouseUtil.getX();
        double mouseY = MouseUtil.getY();
        this.ingredientListOverlay.drawScreen(minecraft, poseStack, (int)mouseX, (int)mouseY, minecraft.m_91296_());
        this.bookmarkOverlay.drawScreen(minecraft, poseStack, (int)mouseX, (int)mouseY, minecraft.m_91296_());
    }

    public void onDrawForeground(AbstractContainerScreen<?> screen, PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.ingredientListOverlay.drawOnForeground(minecraft, poseStack, screen, mouseX, mouseY);
    }

    public void onDrawScreenPost(Screen screen, PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.ingredientListOverlay.updateScreen(screen, null);
        this.bookmarkOverlay.updateScreen(screen, null);
        if (!this.drawnOnBackground) {
            if (screen instanceof AbstractContainerScreen) {
                String guiName = screen.getClass().getName();
                missingBackgroundLogger.log(Level.WARN, guiName, "GUI did not draw the dark background layer behind itself, this may result in display issues: {}", guiName);
            }
            this.ingredientListOverlay.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.m_91296_());
            this.bookmarkOverlay.drawScreen(minecraft, poseStack, mouseX, mouseY, minecraft.m_91296_());
        }
        this.drawnOnBackground = false;
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            IPlatformScreenHelper screenHelper = Services.PLATFORM.getScreenHelper();
            int guiLeft = screenHelper.getGuiLeft(guiContainer);
            int guiTop = screenHelper.getGuiTop(guiContainer);
            this.screenHelper.getGuiClickableArea(guiContainer, mouseX - guiLeft, mouseY - guiTop).filter(IGuiClickableArea::isTooltipEnabled).map(IGuiClickableArea::getTooltipStrings).findFirst().ifPresent(tooltipStrings -> {
                if (tooltipStrings.isEmpty()) {
                    tooltipStrings = List.of(Component.m_237115_((String)"jei.tooltip.show.recipes"));
                }
                TooltipRenderer.drawHoveringText(poseStack, tooltipStrings, mouseX, mouseY);
            });
        }
        this.ingredientListOverlay.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        this.bookmarkOverlay.drawTooltips(minecraft, poseStack, mouseX, mouseY);
        if (DebugConfig.isDebugModeEnabled()) {
            this.drawDebugInfoForScreen(screen, poseStack);
        }
    }

    public void onClientTick() {
        this.ingredientListOverlay.handleTick();
    }

    public boolean renderCompactPotionIndicators() {
        return this.ingredientListOverlay.isListDisplayed();
    }

    private void drawDebugInfoForScreen(Screen screen, PoseStack poseStack) {
        RectDebugger.INSTANCE.draw(poseStack);
        this.screenHelper.getGuiProperties(screen).ifPresent(guiProperties -> {
            Set guiExclusionAreas = this.screenHelper.getGuiExclusionAreas(screen).collect(Collectors.toUnmodifiableSet());
            RenderSystem.m_69465_();
            for (Rect2i area : guiExclusionAreas) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)area.m_110085_(), (int)area.m_110086_(), (int)(area.m_110085_() + area.m_110090_()), (int)(area.m_110086_() + area.m_110091_()), (int)0x44FF0000);
            }
            GuiComponent.m_93172_((PoseStack)poseStack, (int)guiProperties.getGuiLeft(), (int)guiProperties.getGuiTop(), (int)(guiProperties.getGuiLeft() + guiProperties.getGuiXSize()), (int)(guiProperties.getGuiTop() + guiProperties.getGuiYSize()), (int)0x22CCCC00);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        });
    }
}

