/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformFluidHelperInternal;
import mezz.jei.library.render.FluidTankRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FluidHelper
implements IPlatformFluidHelperInternal<FluidStack> {
    @Override
    public IIngredientTypeWithSubtypes<Fluid, FluidStack> getFluidIngredientType() {
        return ForgeTypes.FLUID_STACK;
    }

    @Override
    public IIngredientSubtypeInterpreter<FluidStack> getAllNbtSubtypeInterpreter() {
        return AllFluidNbt.INSTANCE;
    }

    @Override
    public IIngredientRenderer<FluidStack> createRenderer(long capacity, boolean showCapacity, int width, int height) {
        return new FluidTankRenderer<FluidStack>(this, capacity, showCapacity, width, height);
    }

    @Override
    public int getColorTint(FluidStack ingredient) {
        Fluid fluid = ingredient.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor(ingredient);
    }

    @Override
    public long getAmount(FluidStack ingredient) {
        return ingredient.getAmount();
    }

    @Override
    public Optional<CompoundTag> getTag(FluidStack ingredient) {
        return Optional.ofNullable(ingredient.getTag());
    }

    @Override
    public List<Component> getTooltip(FluidStack ingredient, TooltipFlag tooltipFlag) {
        ResourceLocation resourceLocation;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Fluid fluid = ingredient.getFluid();
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return tooltip;
        }
        Component displayName = this.getDisplayName(ingredient);
        tooltip.add(displayName);
        if (tooltipFlag.m_7050_() && (resourceLocation = ForgeRegistries.FLUIDS.getKey((Object)fluid)) != null) {
            MutableComponent advancedId = Component.m_237113_((String)resourceLocation.toString()).m_130940_(ChatFormatting.DARK_GRAY);
            tooltip.add((Component)advancedId);
        }
        return tooltip;
    }

    @Override
    public long bucketVolume() {
        return 1000L;
    }

    @Override
    public Optional<TextureAtlasSprite> getStillFluidSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture(fluidStack);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
        return Optional.of(sprite).filter(s -> s.m_247685_() != MissingTextureAtlasSprite.m_118071_());
    }

    @Override
    public Component getDisplayName(FluidStack ingredient) {
        return ingredient.getDisplayName();
    }

    @Override
    public FluidStack create(Fluid fluid, long amount, @Nullable CompoundTag tag) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack(fluid, intAmount, tag);
    }

    @Override
    public FluidStack create(Fluid fluid, long amount) {
        int intAmount = (int)Math.min(amount, Integer.MAX_VALUE);
        return new FluidStack(fluid, intAmount);
    }

    @Override
    public FluidStack copy(FluidStack ingredient) {
        return ingredient.copy();
    }

    @Override
    public FluidStack normalize(FluidStack ingredient) {
        FluidStack copy = this.copy(ingredient);
        copy.setAmount(1000);
        return copy;
    }

    private static class AllFluidNbt
    implements IIngredientSubtypeInterpreter<FluidStack> {
        public static final AllFluidNbt INSTANCE = new AllFluidNbt();

        private AllFluidNbt() {
        }

        @Override
        public String apply(FluidStack fluidStack, UidContext context) {
            CompoundTag nbtTagCompound = fluidStack.getTag();
            if (nbtTagCompound == null || nbtTagCompound.m_128456_()) {
                return "";
            }
            return nbtTagCompound.toString();
        }
    }
}

