/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.input.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IWorldConfig;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.util.ServerCommandUtil;
import mezz.jei.gui.config.IClientConfig;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.overlay.IIngredientGrid;
import mezz.jei.gui.util.CheatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IIngredientGrid ingredientGrid;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;
    private final CheatUtil cheatUtil;

    public DeleteItemInputHandler(IIngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection, CheatUtil cheatUtil) {
        this.ingredientGrid = ingredientGrid;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
        this.cheatUtil = cheatUtil;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput userInput, IInternalKeyMappings keyBindings) {
        double mouseY;
        if (!userInput.is(keyBindings.getLeftClick())) {
            return Optional.empty();
        }
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
            PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
            this.serverConnection.sendPacketToServer(packet);
        }
        return Optional.of(this);
    }

    public void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        MutableComponent deleteItem = Component.m_237115_((String)"jei.tooltip.delete.item");
        TooltipRenderer.drawHoveringText(poseStack, List.of(deleteItem), mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        if (!this.worldConfig.isCheatItemsEnabled() || !this.serverConnection.isJeiOnServer()) {
            return false;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(this.cheatUtil::getCheatItemStack).map(i -> !ServerCommandUtil.canStack(itemStack, i)).orElse(true);
        }
        return true;
    }
}

