/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.config.IWorldConfig;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.overlay.ElementRenderer;
import mezz.jei.gui.overlay.ElementRenderersByType;
import mezz.jei.gui.overlay.IngredientListSlot;
import net.minecraft.client.gui.GuiComponent;

public class IngredientListRenderer {
    private static final int BLACKLIST_COLOR = -65536;
    private final List<IngredientListSlot> slots = new ArrayList<IngredientListSlot>();
    private final ElementRenderersByType renderers = new ElementRenderersByType();
    private final IEditModeConfig editModeConfig;
    private final IWorldConfig worldConfig;
    private final IIngredientManager ingredientManager;
    private int blocked = 0;

    public IngredientListRenderer(IEditModeConfig editModeConfig, IWorldConfig worldConfig, IIngredientManager ingredientManager) {
        this.editModeConfig = editModeConfig;
        this.worldConfig = worldConfig;
        this.ingredientManager = ingredientManager;
    }

    public void clear() {
        this.slots.clear();
        this.renderers.clear();
        this.blocked = 0;
    }

    public int size() {
        return this.slots.size() - this.blocked;
    }

    public void add(IngredientListSlot ingredientListSlot) {
        this.slots.add(ingredientListSlot);
    }

    public Stream<IngredientListSlot> getSlots() {
        return this.slots.stream().filter(s -> !s.isBlocked());
    }

    public void set(int startIndex, List<ITypedIngredient<?>> ingredientList) {
        this.renderers.clear();
        this.blocked = 0;
        int i = startIndex;
        for (IngredientListSlot ingredientListSlot : this.slots) {
            if (ingredientListSlot.isBlocked()) {
                ingredientListSlot.clear();
                ++this.blocked;
                continue;
            }
            if (i >= ingredientList.size()) {
                ingredientListSlot.clear();
            } else {
                ITypedIngredient<?> ingredient = ingredientList.get(i);
                this.set(ingredientListSlot, ingredient);
            }
            ++i;
        }
    }

    private <V> void set(IngredientListSlot ingredientListSlot, ITypedIngredient<V> value) {
        ElementRenderer<V> renderer = new ElementRenderer<V>(value);
        ingredientListSlot.setIngredientRenderer(renderer);
        IIngredientType<V> ingredientType = value.getType();
        this.renderers.put(ingredientType, renderer);
    }

    public void render(PoseStack poseStack) {
        for (IIngredientType<?> ingredientType : this.renderers.getTypes()) {
            this.renderIngredientType(poseStack, ingredientType);
        }
    }

    private <T> void renderIngredientType(PoseStack poseStack, IIngredientType<T> ingredientType) {
        Collection<ElementRenderer<T>> slots = this.renderers.get(ingredientType);
        IIngredientRenderer<T> ingredientRenderer = this.ingredientManager.getIngredientRenderer(ingredientType);
        for (ElementRenderer<T> slot : slots) {
            this.renderIngredient(poseStack, slot, ingredientRenderer);
        }
    }

    private <T> void renderIngredient(PoseStack poseStack, ElementRenderer<T> slot, IIngredientRenderer<T> ingredientRenderer) {
        ITypedIngredient<T> typedIngredient = slot.getTypedIngredient();
        ImmutableRect2i area = slot.getArea();
        int slotPadding = slot.getPadding();
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientListRenderer.renderEditMode(poseStack, area, slotPadding, this.editModeConfig, typedIngredient);
            RenderSystem.m_69478_();
        }
        T ingredient = typedIngredient.getIngredient();
        try {
            int xPosition = area.getX() + slotPadding;
            int yPosition = area.getY() + slotPadding;
            poseStack.m_85836_();
            poseStack.m_252880_((float)xPosition, (float)yPosition, 0.0f);
            ingredientRenderer.render(poseStack, ingredient);
            poseStack.m_85849_();
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, ingredient, this.ingredientManager);
        }
    }

    private static <T> void renderEditMode(PoseStack poseStack, ImmutableRect2i area, int padding, IEditModeConfig editModeConfig, ITypedIngredient<T> typedIngredient) {
        if (editModeConfig.isIngredientHiddenUsingConfigFile(typedIngredient)) {
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(area.getX() + padding), (int)(area.getY() + padding), (int)(area.getX() + 16 + padding), (int)(area.getY() + 16 + padding), (int)-65536);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

