/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import mezz.jei.common.util.TagUtil;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;
    private final IColorHelper colorHelper;

    public ItemStackHelper(StackHelper stackHelper, IColorHelper colorHelper) {
        this.stackHelper = stackHelper;
        this.colorHelper = colorHelper;
    }

    @Override
    public IIngredientType<ItemStack> getIngredientType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        Component displayNameTextComponent = ingredient.m_41786_();
        String displayName = displayNameTextComponent.getString();
        ErrorUtil.checkNotNull(displayName, "itemStack.getDisplayName()");
        return displayName;
    }

    @Override
    public String getUniqueId(ItemStack ingredient, UidContext context) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, context);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return StackHelper.getRegistryNameForStack(ingredient);
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
        return itemStackHelper.getCreatorModId(ingredient).or(() -> Services.PLATFORM.getRegistry(Registries.f_256913_).getRegistryName(ingredient.m_41720_()).map(ResourceLocation::m_135827_)).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("null registryName for: " + stackInfo);
        });
    }

    @Override
    public Iterable<Integer> getColors(ItemStack ingredient) {
        return this.colorHelper.getColors(ingredient, 2);
    }

    @Override
    public ResourceLocation getResourceLocation(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.m_41720_();
        return Services.PLATFORM.getRegistry(Registries.f_256913_).getRegistryName(item).orElseThrow(() -> {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        });
    }

    @Override
    public ItemStack getCheatItemStack(ItemStack ingredient) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.m_41777_();
    }

    @Override
    public ItemStack normalizeIngredient(ItemStack ingredient) {
        ItemStack copy = ingredient.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.m_41619_();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.m_41720_();
        IPlatformRegistry<Item> registry = Services.PLATFORM.getRegistry(Registries.f_256913_);
        return registry.contains(item);
    }

    @Override
    public Collection<ResourceLocation> getTags(ItemStack ingredient) {
        return this.getTagStream(ingredient).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Stream<ResourceLocation> getTagStream(ItemStack ingredient) {
        return ingredient.m_204131_().map(TagKey::f_203868_);
    }

    @Override
    @Deprecated
    public Collection<String> getCreativeTabNames(ItemStack ingredient) {
        return List.of();
    }

    @Override
    public String getErrorInfo(@Nullable ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }

    @Override
    public Optional<ResourceLocation> getTagEquivalent(Collection<ItemStack> ingredients) {
        return TagUtil.getTagEquivalent(ingredients, ItemStack::m_41720_, () -> ((DefaultedRegistry)BuiltInRegistries.f_257033_).m_203612_());
    }
}

