/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.debug;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IBookmarkOverlay;
import mezz.jei.api.runtime.IIngredientFilter;
import mezz.jei.api.runtime.IIngredientListOverlay;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.library.plugins.debug.DebugRecipe;
import mezz.jei.library.plugins.jei.ingredients.DebugIngredient;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class DebugRecipeCategory<F>
implements IRecipeCategory<DebugRecipe> {
    public static final RecipeType<DebugRecipe> TYPE = RecipeType.create("jei", "debug", DebugRecipe.class);
    public static final int RECIPE_WIDTH = 160;
    public static final int RECIPE_HEIGHT = 60;
    private final IDrawable background;
    private final IPlatformFluidHelper<F> platformFluidHelper;
    private final IIngredientManager ingredientManager;
    private final Component localizedName;
    private final IDrawable tankBackground;
    private final IDrawable tankOverlay;
    private final IDrawable item;
    @Nullable
    private IJeiRuntime runtime;
    private boolean hiddenRecipes;

    public DebugRecipeCategory(IGuiHelper guiHelper, IPlatformFluidHelper<F> platformFluidHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createBlankDrawable(160, 60);
        this.platformFluidHelper = platformFluidHelper;
        this.ingredientManager = ingredientManager;
        this.localizedName = Component.m_237113_((String)"debug");
        ResourceLocation backgroundTexture = new ResourceLocation("jei", "textures/jei/gui/debug.png");
        this.tankBackground = guiHelper.createDrawable(backgroundTexture, 220, 196, 18, 60);
        this.tankOverlay = guiHelper.createDrawable(backgroundTexture, 238, 196, 18, 60);
        this.item = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)Items.f_41900_));
    }

    public void setRuntime(IJeiRuntime runtime) {
        this.runtime = runtime;
    }

    @Override
    public RecipeType<DebugRecipe> getRecipeType() {
        return TYPE;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public IDrawable getIcon() {
        Textures textures = Internal.getTextures();
        return textures.getConfigButtonIcon();
    }

    @Override
    public void draw(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.runtime != null) {
            this.item.draw(guiGraphics, 50, 20);
            IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
            Minecraft minecraft = Minecraft.m_91087_();
            guiGraphics.m_280056_(minecraft.f_91062_, ingredientFilter.getFilterText(), 20, 52, 0, false);
            IIngredientListOverlay ingredientListOverlay = this.runtime.getIngredientListOverlay();
            Optional<ITypedIngredient<?>> ingredientUnderMouse = DebugRecipeCategory.getIngredientUnderMouse(ingredientListOverlay, this.runtime.getBookmarkOverlay());
            ingredientUnderMouse.ifPresent(typedIngredient -> this.drawIngredientName(minecraft, guiGraphics, (ITypedIngredient)typedIngredient));
        }
        Button button = recipe.getButton();
        button.m_88315_(guiGraphics, (int)mouseX, (int)mouseY, 0.0f);
    }

    private static Optional<ITypedIngredient<?>> getIngredientUnderMouse(IIngredientListOverlay ingredientListOverlay, IBookmarkOverlay bookmarkOverlay) {
        return ingredientListOverlay.getIngredientUnderMouse().or(bookmarkOverlay::getIngredientUnderMouse);
    }

    private <T> void drawIngredientName(Minecraft minecraft, GuiGraphics guiGraphics, ITypedIngredient<T> ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient.getType());
        String jeiUid = ingredientHelper.getUniqueId(ingredient.getIngredient(), UidContext.Ingredient);
        guiGraphics.m_280056_(minecraft.f_91062_, jeiUid, 50, 52, 0, false);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, DebugRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 70, 0).addItemStack(new ItemStack((ItemLike)Items.f_41961_))).addItemStack(new ItemStack((ItemLike)Items.f_151058_));
        builder.addSlot(RecipeIngredientRole.INPUT, 110, 0).addIngredientsUnsafe(Arrays.asList(new ItemStack((ItemLike)Items.f_42697_), null));
        long bucketVolume = this.platformFluidHelper.bucketVolume();
        IIngredientTypeWithSubtypes<Fluid, F> fluidType = this.platformFluidHelper.getFluidIngredientType();
        long capacity = 10L * bucketVolume;
        long amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 90, 0).setFluidRenderer(capacity, false, 16, 58).setOverlay(this.tankOverlay, -1, -1).setBackground(this.tankBackground, -1, -1).addFluidStack((Fluid)Fluids.f_76193_, amount);
        capacity = 2L * bucketVolume;
        amount = capacity / 2L + (long)((int)(Math.random() * (double)capacity / 2.0));
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 0).setFluidRenderer(capacity, true, 12, 47).addIngredient(fluidType, this.platformFluidHelper.create((Fluid)Fluids.f_76195_, amount));
        builder.addSlot(RecipeIngredientRole.INPUT, 40, 0).addIngredients(DebugIngredient.TYPE, List.of(new DebugIngredient(0), new DebugIngredient(1)));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 40, 16).addIngredient(DebugIngredient.TYPE, new DebugIngredient(2));
        ((IRecipeSlotBuilder)((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 40, 32).addIngredient(DebugIngredient.TYPE, new DebugIngredient(3))).addIngredientsUnsafe(List.of(this.platformFluidHelper.create((Fluid)Fluids.f_76195_, (int)((1.0 + Math.random()) * (double)bucketVolume)), new ItemStack((ItemLike)Items.f_41900_)))).addTooltipCallback((recipeSlotView, tooltip) -> {
            switch (recipeSlotView.getRole()) {
                case INPUT: {
                    tooltip.add(Component.m_237113_((String)"Input DebugIngredient"));
                    break;
                }
                case OUTPUT: {
                    tooltip.add(Component.m_237113_((String)"Output DebugIngredient"));
                    break;
                }
                case CATALYST: {
                    tooltip.add(Component.m_237113_((String)"Catalyst DebugIngredient"));
                }
            }
        });
    }

    @Override
    public List<Component> getTooltipStrings(DebugRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltipStrings = new ArrayList<Component>();
        tooltipStrings.add((Component)Component.m_237113_((String)"Debug Recipe Category Tooltip is very long and going to wrap").m_130940_(ChatFormatting.GOLD));
        if (recipe.checkHover(mouseX, mouseY)) {
            tooltipStrings.add((Component)Component.m_237113_((String)"button tooltip!"));
        } else {
            MutableComponent debug = Component.m_237113_((String)"tooltip debug");
            tooltipStrings.add((Component)debug.m_130940_(ChatFormatting.BOLD));
        }
        tooltipStrings.add((Component)Component.m_237113_((String)(mouseX + ", " + mouseY)));
        return tooltipStrings;
    }

    @Override
    public boolean handleInput(DebugRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() != InputConstants.Type.MOUSE) {
            return false;
        }
        Button button = recipe.getButton();
        int mouseButton = input.m_84873_();
        if (mouseButton == 0 && button.m_6375_(mouseX, mouseY, mouseButton)) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                InventoryScreen screen = new InventoryScreen((Player)player);
                minecraft.m_91152_((Screen)screen);
            }
            if (this.runtime != null) {
                IIngredientFilter ingredientFilter = this.runtime.getIngredientFilter();
                String filterText = ingredientFilter.getFilterText();
                ingredientFilter.setFilterText(filterText + " test");
                IRecipeManager recipeManager = this.runtime.getRecipeManager();
                if (!this.hiddenRecipes) {
                    recipeManager.hideRecipeCategory(RecipeTypes.CRAFTING);
                    this.hiddenRecipes = true;
                } else {
                    recipeManager.unhideRecipeCategory(RecipeTypes.CRAFTING);
                    this.hiddenRecipes = false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ResourceLocation getRegistryName(DebugRecipe recipe) {
        return recipe.getRegistryName();
    }
}

