/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.Translator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Unmodifiable;

public final class IngredientInformationUtil {
    private IngredientInformationUtil() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformationUtil.removeChatFormatting(displayName);
    }

    public static <T> @Unmodifiable List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove, IIngredientFilterConfig config) {
        TooltipFlag.Default tooltipFlag = config.getSearchAdvancedTooltips() ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        List<Component> tooltip = ingredientRenderer.getTooltip(ingredient, (TooltipFlag)tooltipFlag);
        return tooltip.stream().map(Component::getString).map(IngredientInformationUtil::removeChatFormatting).map(Translator::toLowercaseWithLocale).map(line -> {
            for (String excludeWord : toRemove) {
                line = line.replace(excludeWord, "");
            }
            return line;
        }).filter(line -> !StringUtil.m_14408_((String)line)).toList();
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.m_126649_((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }
}

