/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.plugins.vanilla.ingredients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.common.util.StackHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStackListFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ItemStack> create(StackHelper stackHelper) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        HashSet<String> itemNameSet = new HashSet<String>();
        Minecraft minecraft = Minecraft.m_91087_();
        FeatureFlagSet features = Optional.of(minecraft).map(m -> m.f_91074_).map(p -> p.f_108617_).map(ClientPacketListener::m_247016_).orElse(FeatureFlagSet.m_246902_());
        boolean hasPermissions = (Boolean)minecraft.f_91066_.m_257871_().m_231551_() != false || Optional.of(minecraft).map(m -> m.f_91074_).map(Player::m_36337_).orElse(false) != false;
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("minecraft.level must be set before JEI fetches ingredients");
        }
        RegistryAccess registryAccess = level.m_9598_();
        CreativeModeTab.ItemDisplayParameters displayParameters = new CreativeModeTab.ItemDisplayParameters(features, hasPermissions, (HolderLookup.Provider)registryAccess);
        for (CreativeModeTab itemGroup : CreativeModeTabs.m_257478_()) {
            Collection creativeTabItemStacks;
            if (itemGroup.m_257962_() != CreativeModeTab.Type.CATEGORY) continue;
            try {
                itemGroup.m_269498_(displayParameters);
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while building contents.Items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            try {
                creativeTabItemStacks = itemGroup.m_260957_();
            }
            catch (LinkageError | RuntimeException e) {
                LOGGER.error("Item Group crashed while getting display items.Some items from this group will be missing from the JEI ingredient list. {}", (Object)itemGroup, (Object)e);
                continue;
            }
            for (ItemStack itemStack : creativeTabItemStacks) {
                if (itemStack.m_41619_()) {
                    LOGGER.error("Found an empty itemStack from creative tab: {}", (Object)itemGroup);
                    continue;
                }
                ItemStackListFactory.addItemStack(stackHelper, itemStack, itemList, itemNameSet);
            }
        }
        return itemList;
    }

    private static void addItemStack(StackHelper stackHelper, ItemStack stack, List<ItemStack> itemList, Set<String> itemNameSet) {
        String itemKey;
        if (stack.m_41720_() == Items.f_42680_) {
            return;
        }
        try {
            itemKey = stackHelper.getUniqueIdentifierForStack(stack, UidContext.Ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            String stackInfo = ErrorUtil.getItemStackInfo(stack);
            LOGGER.error("Couldn't get unique name for itemStack {}", (Object)stackInfo, (Object)e);
            return;
        }
        if (!itemNameSet.contains(itemKey)) {
            itemNameSet.add(itemKey);
            itemList.add(stack);
        }
    }
}

