/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.startup;

import mezz.jei.forge.events.RuntimeEventSubscriptions;
import mezz.jei.forge.input.ForgeUserInput;
import mezz.jei.gui.events.GuiEventHandler;
import mezz.jei.gui.input.ClientInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.startup.JeiEventHandlers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.ScreenEvent;

public class EventRegistration {
    public static void registerEvents(RuntimeEventSubscriptions subscriptions, JeiEventHandlers eventHandlers) {
        ClientInputHandler clientInputHandler = eventHandlers.clientInputHandler();
        EventRegistration.registerClientInputHandler(subscriptions, clientInputHandler);
        GuiEventHandler guiEventHandler = eventHandlers.guiEventHandler();
        EventRegistration.registerGuiHandler(subscriptions, guiEventHandler);
    }

    private static void registerClientInputHandler(RuntimeEventSubscriptions subscriptions, ClientInputHandler handler) {
        subscriptions.register(ScreenEvent.Init.Post.class, event -> handler.onInitGui());
        subscriptions.register(ScreenEvent.KeyPressed.Pre.class, event -> {
            UserInput input;
            Screen screen = event.getScreen();
            if (handler.onKeyboardKeyPressedPre(screen, input = ForgeUserInput.fromEvent((ScreenEvent.KeyPressed)event))) {
                event.setCanceled(true);
            }
        });
        subscriptions.register(ScreenEvent.KeyPressed.Post.class, event -> {
            UserInput input;
            Screen screen = event.getScreen();
            if (handler.onKeyboardKeyPressedPost(screen, input = ForgeUserInput.fromEvent((ScreenEvent.KeyPressed)event))) {
                event.setCanceled(true);
            }
        });
        subscriptions.register(ScreenEvent.CharacterTyped.Pre.class, event -> {
            int modifiers;
            char codePoint;
            Screen screen = event.getScreen();
            if (handler.onKeyboardCharTypedPre(screen, codePoint = event.getCodePoint(), modifiers = event.getModifiers())) {
                event.setCanceled(true);
            }
        });
        subscriptions.register(ScreenEvent.CharacterTyped.Post.class, event -> {
            Screen screen = event.getScreen();
            char codePoint = event.getCodePoint();
            int modifiers = event.getModifiers();
            handler.onKeyboardCharTypedPost(screen, codePoint, modifiers);
        });
        subscriptions.register(ScreenEvent.MouseButtonPressed.Pre.class, event -> ForgeUserInput.fromEvent((ScreenEvent.MouseButtonPressed)event).ifPresent(input -> {
            Screen screen = event.getScreen();
            if (handler.onGuiMouseClicked(screen, (UserInput)input)) {
                event.setCanceled(true);
            }
        }));
        subscriptions.register(ScreenEvent.MouseButtonReleased.Pre.class, event -> ForgeUserInput.fromEvent((ScreenEvent.MouseButtonReleased)event).ifPresent(input -> {
            Screen screen = event.getScreen();
            if (handler.onGuiMouseReleased(screen, (UserInput)input)) {
                event.setCanceled(true);
            }
        }));
        subscriptions.register(ScreenEvent.MouseScrolled.Pre.class, event -> {
            double scrollDeltaY;
            double scrollDeltaX;
            double mouseY;
            double mouseX = event.getMouseX();
            if (handler.onGuiMouseScroll(mouseX, mouseY = event.getMouseY(), scrollDeltaX = event.getDeltaX(), scrollDeltaY = event.getDeltaY())) {
                event.setCanceled(true);
            }
        });
    }

    public static void registerGuiHandler(RuntimeEventSubscriptions subscriptions, GuiEventHandler guiEventHandler) {
        subscriptions.register(ScreenEvent.Init.Post.class, event -> {
            Screen screen = event.getScreen();
            guiEventHandler.onGuiInit(screen);
        });
        subscriptions.register(ScreenEvent.Opening.class, event -> {
            Screen screen = event.getScreen();
            guiEventHandler.onGuiOpen(screen);
        });
        subscriptions.register(ScreenEvent.BackgroundRendered.class, event -> {
            Screen screen = event.getScreen();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            guiEventHandler.onDrawBackgroundPost(screen, guiGraphics);
        });
        subscriptions.register(ContainerScreenEvent.Render.Foreground.class, event -> {
            AbstractContainerScreen containerScreen = event.getContainerScreen();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            guiEventHandler.onDrawForeground(containerScreen, guiGraphics, mouseX, mouseY);
        });
        subscriptions.register(ScreenEvent.Render.Post.class, event -> {
            Screen screen = event.getScreen();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            guiEventHandler.onDrawScreenPost(screen, guiGraphics, mouseX, mouseY);
        });
        subscriptions.register(ScreenEvent.RenderInventoryMobEffects.class, event -> {
            if (guiEventHandler.renderCompactPotionIndicators()) {
                event.setCompact(true);
            }
        });
    }
}

