/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.ingredients.itemStacks;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.library.ingredients.itemStacks.NormalizedTypedItem;
import mezz.jei.library.ingredients.itemStacks.TypedItemStack;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record NormalizedTypedItemStack(Holder<Item> itemHolder, DataComponentPatch dataComponentPatch) implements ITypedIngredient<ItemStack>
{
    public static ITypedIngredient<ItemStack> normalize(ITypedIngredient<ItemStack> typedIngredient) {
        ITypedIngredient<ItemStack> iTypedIngredient = typedIngredient;
        Objects.requireNonNull(iTypedIngredient);
        ITypedIngredient<ItemStack> iTypedIngredient2 = iTypedIngredient;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NormalizedTypedItemStack.class, NormalizedTypedItem.class, TypedItemStack.class}, iTypedIngredient2, n)) {
            case 0: {
                NormalizedTypedItemStack normalized = (NormalizedTypedItemStack)iTypedIngredient2;
                return normalized;
            }
            case 1: {
                NormalizedTypedItem normalized = (NormalizedTypedItem)iTypedIngredient2;
                return normalized;
            }
            case 2: {
                TypedItemStack typedItemStack = (TypedItemStack)iTypedIngredient2;
                return NormalizedTypedItemStack.create(typedItemStack.itemHolder(), typedItemStack.dataComponentPatch());
            }
        }
        ItemStack itemStack = typedIngredient.getIngredient();
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getComponentsPatch());
    }

    public static ITypedIngredient<ItemStack> create(Holder<Item> itemHolder, DataComponentPatch dataComponentPatch) {
        if (dataComponentPatch.isEmpty()) {
            return new NormalizedTypedItem(itemHolder);
        }
        return new NormalizedTypedItemStack(itemHolder, dataComponentPatch);
    }

    public static ITypedIngredient<ItemStack> create(ItemStack itemStack) {
        return NormalizedTypedItemStack.create((Holder<Item>)itemStack.getItemHolder(), itemStack.getComponentsPatch());
    }

    @Override
    public ItemStack getIngredient() {
        return new ItemStack(this.itemHolder, 1, this.dataComponentPatch);
    }

    @Override
    public Optional<ItemStack> getItemStack() {
        return Optional.of(this.getIngredient());
    }

    @Override
    public IIngredientType<ItemStack> getType() {
        return VanillaTypes.ITEM_STACK;
    }

    @Override
    public String toString() {
        return "NormalizedTypedItemStack{itemHolder=" + String.valueOf(this.itemHolder) + ", dataComponentPatch=" + String.valueOf(this.dataComponentPatch) + "}";
    }
}

