/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.event.EntityRadarUpdateEvent;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.model.EntityDTO;
import journeymap.client.properties.InGameMapProperties;
import journeymap.client.ui.UIManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class EntityRadarUpdateEventHandler {
    public static EntityRadarUpdateEventHandler INSTANCE;

    private EntityRadarUpdateEventHandler() {
        ClientEventRegistry.ENTITY_RADAR_UPDATE_EVENT.subscribe("journeymap", this::onRadarEntityUpdateEvent);
    }

    public static EntityRadarUpdateEventHandler init() {
        if (INSTANCE == null) {
            INSTANCE = new EntityRadarUpdateEventHandler();
        }
        return INSTANCE;
    }

    private void onRadarEntityUpdateEvent(EntityRadarUpdateEvent event) {
        Entity livingEntity;
        if (JourneymapClient.getInstance().enabled() && !event.isCancelled() && event.getActiveUiState() != null && EntityRadarUpdateEvent.EntityType.MOB.equals((Object)event.getType()) && (livingEntity = (Entity)event.getWrappedEntity().getEntityRef().get()) != null) {
            boolean showNames = EntityRadarUpdateEventHandler.getProperties((UIState)event.getActiveUiState()).showEntityNames.get();
            Component name = EntityRadarUpdateEventHandler.getEntityName((EntityDTO)event.getWrappedEntity(), event.getActiveUiState(), showNames);
            if (!event.getWrappedEntity().isSneaking() && name != null) {
                event.getWrappedEntity().setCustomName(name);
                EntityRadarUpdateEventHandler.addEntityToolTips((EntityDTO)event.getWrappedEntity(), event.getActiveUiState(), name, showNames);
            }
        }
    }

    public static Component getEntityName(EntityDTO entity, UIState activeUiState, boolean showNames) {
        InGameMapProperties properties = EntityRadarUpdateEventHandler.getProperties(activeUiState);
        MutableComponent name = null;
        String baseName = null;
        Entity livingEntity = (Entity)entity.entityRef.get();
        if (livingEntity != null) {
            if (showNames && properties.showHostileNames.get().booleanValue() && entity.getHostile().booleanValue()) {
                baseName = livingEntity.getName().getString();
            } else if (showNames && properties.showPassiveNames.get().booleanValue() && entity.isPassiveAnimal()) {
                baseName = livingEntity.getName().getString();
            } else if (showNames && properties.showPetNames.get().booleanValue() && entity.owner != null) {
                baseName = livingEntity.getName().getString();
            } else if (showNames && properties.showNpcNames.get().booleanValue() && entity.isNpc()) {
                baseName = livingEntity.getName().getString();
            } else if (showNames && properties.showVillagerNames.get().booleanValue() && entity.getProfession() != null) {
                baseName = livingEntity.getName().getString();
            } else if (showNames && properties.showAmbientNames.get().booleanValue() && entity.isAmbientCreature()) {
                baseName = livingEntity.getName().getString();
            } else if (properties.showNoIconNames.get().booleanValue() && entity.getEntityIconLocation() == null) {
                baseName = livingEntity.getName().getString();
            }
            if (baseName != null) {
                name = Component.literal((String)baseName);
                name.withStyle(style -> style.withColor(entity.getLabelColor()).withBold(Boolean.valueOf(true)));
            }
        }
        return name;
    }

    public static void addEntityToolTips(EntityDTO entity, UIState activeUiState, Component name, boolean showNames) {
        InGameMapProperties properties = EntityRadarUpdateEventHandler.getProperties(activeUiState);
        if (!entity.isSneaking() && name != null) {
            MutableComponent profession = null;
            Entity livingEntity = (Entity)entity.getEntityRef().get();
            if (showNames && properties.showVillagerNames.get().booleanValue() && entity.getProfession() != null) {
                profession = Component.literal((String)(Constants.getString("jm.common.profession.label") + entity.getProfession()));
                int color = 0xFFFFFF;
                profession.withStyle(style -> style.withColor(color));
            }
            String id = livingEntity.getEncodeId();
            MutableComponent resource = null;
            if (id != null) {
                resource = Component.literal((String)id);
                int color = 0xFFFFFF;
                resource.withStyle(style -> style.withColor(color));
            }
            EntityRadarUpdateEventHandler.addToolTips(entity, new Component[]{name, profession, resource});
        }
    }

    private static InGameMapProperties getProperties(UIState activeUiState) {
        if (Context.UI.Minimap.equals((Object)activeUiState.ui)) {
            return UIManager.INSTANCE.getMiniMap().getCurrentMinimapProperties();
        }
        return JourneymapClient.getInstance().getFullMapProperties();
    }

    private static void addToolTips(EntityDTO entity, Component ... toolTips) {
        ArrayList<Component> tips = new ArrayList<Component>();
        for (Component tt : toolTips) {
            if (tt == null) continue;
            tips.add(tt);
        }
        if (!tips.isEmpty()) {
            entity.setEntityToolTips(tips);
        }
    }
}

