/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionData;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;

public class NBTChunkMD
extends ChunkMD {
    final CompoundTag data;
    final LevelChunk chunk;
    final ChunkPos chunkPos;
    final MapType mapType;

    public NBTChunkMD(LevelChunk chunk, ChunkPos chunkPos, CompoundTag data, MapType mapType) {
        super(chunk, false);
        this.chunk = chunk;
        this.mapType = mapType;
        this.data = data;
        this.chunkPos = chunkPos;
    }

    @Override
    public boolean hasChunk() {
        return this.data != null;
    }

    @Override
    public LevelChunk getChunk() {
        return this.chunk;
    }

    @Override
    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
    }

    @Override
    public BlockState getChunkBlockState(BlockPos blockPos) {
        BlockState state = this.getBlockState(blockPos);
        return state;
    }

    @Override
    public int getSavedLightValue(int localX, int y, int localZ) {
        BlockPos pos = this.getBlockPos(localX, y, localZ);
        return this.getGetLightValue(pos);
    }

    @Override
    public BlockMD getBlockMD(BlockPos blockPos) {
        return BlockMD.get(this.getBlockState(blockPos));
    }

    @Override
    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        return !this.mapType.isUnderground();
    }

    @Override
    public int getPrecipitationHeight(BlockPos blockPos) {
        return this.getTopY(blockPos);
    }

    @Override
    public int getHeight(BlockPos blockPos) {
        BlockPos pos = new BlockPos(this.toWorldX(blockPos.getX()), blockPos.getY(), this.toWorldZ(blockPos.getZ()));
        Integer surfaceY = this.getSurfaceY(pos);
        if (surfaceY == null) {
            surfaceY = this.getTopY(pos);
        }
        return surfaceY;
    }

    @Override
    public BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.get(this.getBlockState(this.getBlockPos(localX, y, localZ)));
    }

    @Override
    public Biome getBiome(BlockPos blockPos) {
        CompoundTag blockData = this.getBlockNBT(blockPos);
        if (blockData.contains("biome_name")) {
            String biomeName = blockData.getString("biome_name");
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundTag blockData = this.getBlockNBT(blockPos);
        if (blockData.contains("top_y")) {
            return blockData.getInt("top_y");
        }
        return blockPos.getY();
    }

    public Integer getGetLightValue(BlockPos blockPos) {
        CompoundTag blockData = this.getBlockNBT(blockPos);
        if (blockData.contains("light_value")) {
            return blockData.getInt("light_value");
        }
        return 0;
    }

    private Integer getSurfaceY(BlockPos blockPos) {
        CompoundTag blockData = this.getBlockNBT(blockPos);
        if (blockData.contains("surface_y")) {
            return blockData.getInt("surface_y");
        }
        return null;
    }

    @Override
    public BlockState getBlockState(BlockPos blockPos) {
        CompoundTag blockData = this.getBlockNBT(blockPos);
        BlockState blockState = RegionData.getBlockState(blockData, blockPos, this.mapType);
        return blockState;
    }

    private CompoundTag getBlockNBT(BlockPos blockPos) {
        return RegionData.getBlockDataForChunk(this.data, blockPos.getX(), blockPos.getZ());
    }

    @Override
    public boolean fromNbt() {
        return true;
    }
}

