/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import commonnetwork.api.Network;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.common.JM;
import journeymap.common.config.AdminAccessConfig;
import journeymap.common.config.AdminConfig;
import journeymap.common.nbt.WorldIdData;
import journeymap.common.network.PacketManager;
import journeymap.common.network.dispatch.NetworkDispatcher;
import journeymap.common.network.handler.PacketHandler;
import journeymap.common.properties.PropertiesManager;
import journeymap.common.version.Version;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Journeymap {
    public static final Version MINIMUM_SERVER_ACCEPTABLE_VERSION = new Version(6, 0, 0, "beta.1");
    public static final Version MINIMUM_CLIENT_ACCEPTABLE_VERSION = new Version(6, 0, 0, "beta.1");
    public static final Version DEV_VERSION = new Version(6, 0, 0, "dev");
    public static final Version JM_VERSION = Version.from(JM.VERSION_MAJOR, JM.VERSION_MINOR, JM.VERSION_MICRO, JM.VERSION_PATCH, new Version(6, 0, 0, "dev"));
    public static final String MOD_ID = "journeymap";
    public static final String SHORT_MOD_NAME = JM.SHORT_MOD_NAME;
    public static final String LOADER_VERSION = JM.LOADER_VERSION;
    public static final String LOADER_NAME = JM.LOADER_NAME;
    public static final String MC_VERSION = JM.MC_VERSION;
    public static final String WEBSITE_URL = JM.WEBSITE_URL;
    public static final String DOWNLOAD_URL = JM.DOWNLOAD_URL;
    public static final String VERSION_URL = JM.VERSION_URL;
    public static boolean DEV_MODE = false;
    private static Journeymap instance;
    private NetworkDispatcher dispatcher;
    private PacketHandler packetHandler;
    private MinecraftServer server;

    public Journeymap() {
        instance = this;
        WaypointFactoryImpl.init();
        PacketManager.init();
    }

    public static Journeymap getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return LogManager.getLogger((String)MOD_ID);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger((String)("journeymap/" + name));
    }

    public void serverStarted(MinecraftServer server) {
        this.server = server;
        this.packetHandler = new PacketHandler();
        WorldIdData.getWorldId();
        PropertiesManager.getInstance();
    }

    public void setAdminConfig(AdminConfig config) {
        AdminAccessConfig.getInstance().load(config);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public NetworkDispatcher getDispatcher() {
        if (this.dispatcher == null) {
            this.dispatcher = new NetworkDispatcher(Network.getNetworkHandler());
        }
        return this.dispatcher;
    }

    public PacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public void serverStopping(MinecraftServer server) {
        this.server = null;
        this.packetHandler = null;
        PropertiesManager.getInstance().clear();
    }
}

