/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import journeymap.common.Journeymap;
import journeymap.common.version.Version;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class HandshakePacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"version");
    public static final StreamCodec<RegistryFriendlyByteBuf, HandshakePacket> STREAM_CODEC = StreamCodec.ofMember(HandshakePacket::encode, HandshakePacket::new);
    private String version;

    public HandshakePacket() {
    }

    public HandshakePacket(String version) {
        this.version = version;
    }

    public HandshakePacket(RegistryFriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.version = buf.readUtf(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for handshake: %s", t));
        }
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    private void encode(RegistryFriendlyByteBuf buf) {
        try {
            buf.writeUtf(this.version);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for handshake: " + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<HandshakePacket> ctx) {
        String jsonString = ((HandshakePacket)ctx.message()).version;
        try {
            Version otherVersion = Version.fromJson(jsonString);
            if (Side.CLIENT.equals((Object)ctx.side())) {
                if (!otherVersion.isValid(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION, ctx.side())) {
                    String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> " + String.valueOf(otherVersion);
                    Minecraft.getInstance().player.connection.getConnection().disconnect((Component)Component.literal((String)message));
                }
            } else if (otherVersion.isValid(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION, ctx.side())) {
                Journeymap.getInstance().getDispatcher().sendHandshakePacket(ctx.sender(), Journeymap.JM_VERSION.toJson());
            } else {
                String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> " + String.valueOf(otherVersion);
                HandshakePacket.disconnect(ctx.sender(), message);
            }
        }
        catch (Exception e) {
            String message = "Error: Likely due to version mismatch " + String.valueOf(ctx.side()) + " is running:" + String.valueOf(Journeymap.JM_VERSION) + " Exception:" + String.valueOf(e);
            HandshakePacket.disconnect(ctx.sender(), message + String.valueOf(e));
        }
    }

    public static void disconnect(ServerPlayer player, String message) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        MutableComponent text = Component.literal((String)message);
        player.connection.send((Packet)new ClientboundSystemChatPacket((Component)text, false));
        executorService.schedule(() -> HandshakePacket.lambda$disconnect$0(player, (Component)text), 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$disconnect$0(ServerPlayer player, Component text) {
        player.connection.disconnect(text);
    }
}

