/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.UUID;
import journeymap.client.data.DataCache;
import journeymap.common.Journeymap;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class RemovePlayerPacket {
    public static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"journeymap", (String)"remove_player");
    public static final StreamCodec<RegistryFriendlyByteBuf, RemovePlayerPacket> STREAM_CODEC = StreamCodec.ofMember(RemovePlayerPacket::encode, RemovePlayerPacket::new);
    private UUID uniqueId;

    public RemovePlayerPacket() {
    }

    public RemovePlayerPacket(UUID id) {
        this.uniqueId = id;
    }

    public static CustomPacketPayload.Type<CustomPacketPayload> type() {
        return new CustomPacketPayload.Type(CHANNEL);
    }

    public RemovePlayerPacket(FriendlyByteBuf buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.uniqueId = buf.readUUID();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for player location request:" + String.valueOf(t));
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeUUID(this.uniqueId);
    }

    public static void handle(PacketContext<RemovePlayerPacket> ctx) {
        if (Side.CLIENT.equals((Object)ctx.side())) {
            Journeymap.getLogger().debug("Removing Player from client uuid:{}", (Object)((RemovePlayerPacket)ctx.message()).uniqueId);
            PlayerRadarManager.getInstance().getPlayers().remove(((RemovePlayerPacket)ctx.message()).uniqueId);
            DataCache.INSTANCE.removePlayer(((RemovePlayerPacket)ctx.message()).uniqueId.toString());
        }
    }
}

