/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Stairs
extends HorizontalDirectionalBlock {
    public static final EnumProperty<ConnectionStatus> CONNECTION = EnumProperty.create((String)"connection", ConnectionStatus.class);
    public static final VoxelShape N = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape E = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape S = Shapes.or((VoxelShape)Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final VoxelShape W = Shapes.or((VoxelShape)Block.box((double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));

    public Bridge_Stairs(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(CONNECTION, (Comparable)((Object)ConnectionStatus.BASE)));
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        BlockState northState = access.getBlockState(pos.north());
        BlockState eastState = access.getBlockState(pos.east());
        BlockState southState = access.getBlockState(pos.south());
        BlockState westState = access.getBlockState(pos.west());
        boolean north = northState.getBlock() == this;
        boolean east = eastState.getBlock() == this;
        boolean south = southState.getBlock() == this;
        boolean west = westState.getBlock() == this;
        ConnectionStatus connection = this.getConnectionStatus((Direction)state.getValue((Property)FACING), north, east, south, west);
        return (BlockState)state.setValue(CONNECTION, (Comparable)((Object)connection));
    }

    private ConnectionStatus getConnectionStatus(Direction facing, boolean north, boolean east, boolean south, boolean west) {
        boolean isConnectedNorthSouth = north && south;
        boolean isConnectedEastWest = east && west;
        switch (facing) {
            case NORTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (south) {
                    return ConnectionStatus.RIGHT;
                }
                if (north) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case SOUTH: {
                if (isConnectedNorthSouth) {
                    return ConnectionStatus.DOUBLE;
                }
                if (north) {
                    return ConnectionStatus.RIGHT;
                }
                if (south) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case EAST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (west) {
                    return ConnectionStatus.RIGHT;
                }
                if (east) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
            case WEST: {
                if (isConnectedEastWest) {
                    return ConnectionStatus.DOUBLE;
                }
                if (east) {
                    return ConnectionStatus.RIGHT;
                }
                if (west) {
                    return ConnectionStatus.LEFT;
                }
                return ConnectionStatus.BASE;
            }
        }
        return ConnectionStatus.BASE;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext contx) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return N;
            }
            case SOUTH: {
                return S;
            }
            case WEST: {
                return W;
            }
        }
        return E;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockItem blockItem;
        if (itemstack.getItem() instanceof BlockItem && (blockItem = (BlockItem)itemstack.getItem()).getBlock() == this) {
            Direction blockFacingDirection = (Direction)state.getValue((Property)FACING);
            Direction facing = player.getDirection();
            BlockPos placePos = pos.relative(facing).above();
            if (level.getBlockState(placePos).isAir()) {
                level.setBlock(placePos, (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockFacingDirection), 3);
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof Bridge_Stairs) {
            return null;
        }
        return (BlockState)this.StairState(super.getStateForPlacement(contx), (LevelAccessor)contx.getLevel(), contx.getClickedPos()).setValue((Property)FACING, (Comparable)contx.getHorizontalDirection().getClockWise());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, CONNECTION});
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public static enum ConnectionStatus implements StringRepresentable
    {
        BASE("base"),
        DOUBLE("double"),
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private ConnectionStatus(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

