/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bridge_Support
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public Bridge_Support(BlockBehaviour.Properties prop) {
        super(prop);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void onBroken(Level level, BlockPos pos) {
        level.levelEvent(1029, pos, 0);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.empty();
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.defaultFluidState() : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        FluidState fluidstate = contx.getLevel().getFluidState(contx.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(contx).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void placeAt(Level level, BlockPos pos) {
        level.setBlock(pos, this.defaultBlockState(), 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }
}

