/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.roofs;

import com.mcwroofs.kikoz.init.ItemInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoofTopNew
extends Block {
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape OCCLUSION = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final EnumProperty<RoofPart> PART = EnumProperty.create((String)"part", RoofPart.class);

    public RoofTopNew(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)RoofPart.SWITCHED_0)));
    }

    public void onBroken(Level worldIn, BlockPos pos) {
        worldIn.levelEvent(1029, pos, 0);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return OCCLUSION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        return BASE;
    }

    private BlockState StairState(BlockState state, LevelAccessor access, BlockPos pos) {
        boolean north = access.getBlockState(pos.north()).getBlock() == this;
        boolean east = access.getBlockState(pos.east()).getBlock() == this;
        boolean south = access.getBlockState(pos.south()).getBlock() == this;
        boolean west = access.getBlockState(pos.west()).getBlock() == this;
        RoofPart connection = this.getConnectionStatus(north, east, south, west);
        return (BlockState)state.setValue(PART, (Comparable)((Object)connection));
    }

    private RoofPart getConnectionStatus(boolean north, boolean east, boolean south, boolean west) {
        if (!north && !south && east && west) {
            return RoofPart.SWITCHED_90;
        }
        if (north && south && east && west) {
            return RoofPart.FOUR_WAY;
        }
        if (north && !south && !east && west) {
            return RoofPart.TOP_OUTER_0;
        }
        if (north && !south && east && !west) {
            return RoofPart.TOP_OUTER_90;
        }
        if (!north && south && east && !west) {
            return RoofPart.TOP_OUTER_180;
        }
        if (!north && south && !east && west) {
            return RoofPart.TOP_OUTER_270;
        }
        if (north && !south && !east && !west) {
            return RoofPart.TOP_END_0;
        }
        if (!north && !south && east && !west) {
            return RoofPart.TOP_END_90;
        }
        if (!north && south && !east && !west) {
            return RoofPart.TOP_END_180;
        }
        if (!north && !south && !east && west) {
            return RoofPart.TOP_END_270;
        }
        if (north && south && east && !west) {
            return RoofPart.THREE_WAY_0;
        }
        if (!north && south && east && west) {
            return RoofPart.THREE_WAY_90;
        }
        if (north && south && !east && west) {
            return RoofPart.THREE_WAY_180;
        }
        if (north && !south && east && west) {
            return RoofPart.THREE_WAY_270;
        }
        return RoofPart.SWITCHED_0;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return this.StairState(state, access, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext contx) {
        BlockPos pos = contx.getClickedPos().below();
        Level world = contx.getLevel();
        BlockState stateBelow = world.getBlockState(pos);
        if (stateBelow.getBlock() instanceof RoofTopNew) {
            return null;
        }
        return this.StairState(super.getStateForPlacement(contx), (LevelAccessor)world, contx.getClickedPos());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            level.setBlock(pos, this.StairState(state, (LevelAccessor)level, pos), 2);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.cycle(PART);
            world.setBlock(pos, state, 1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART});
    }

    public void placeAt(Level world, BlockPos pos, int intos) {
        world.setBlock(pos, this.defaultBlockState(), intos);
    }

    public static enum RoofPart implements StringRepresentable
    {
        PYRAMID("pyramid"),
        SWITCHED_0("switched_0"),
        SWITCHED_90("switched_90"),
        FOUR_WAY("four_way"),
        TOP_END_0("top_end_0"),
        TOP_END_90("top_end_90"),
        TOP_END_180("top_end_180"),
        TOP_END_270("top_end_270"),
        TOP_OUTER_0("top_outer_0"),
        TOP_OUTER_90("top_outer_90"),
        TOP_OUTER_180("top_outer_180"),
        TOP_OUTER_270("top_outer_270"),
        THREE_WAY_0("three_way_0"),
        THREE_WAY_90("three_way_90"),
        THREE_WAY_180("three_way_180"),
        THREE_WAY_270("three_way_270");

        private final String name;

        private RoofPart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

