/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.util.WorldUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockGate
extends DoorBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final String IRON_GATE = "gate_iron";
    public static final String WOODEN_GATE = "gate_wood";
    private final int maxWidth;
    private final int maxHeight;
    private final float hardness;
    protected static final VoxelShape E_W_SHAPE = Shapes.m_83048_((double)0.3, (double)0.0, (double)0.0, (double)0.7, (double)1.0, (double)1.0);
    protected static final VoxelShape N_S_SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.3, (double)1.0, (double)1.0, (double)0.7);
    private final String name;

    public AbstractBlockGate(String name, float hardness, int maxWidth, int maxHeight) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(hardness, hardness * 5.0f).m_60955_(), BlockSetType.f_271100_);
        this.m_49959_(this.m_49966_());
        this.name = name;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.hardness = hardness;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        this.toggleGate(worldIn, pos, ((Direction)state.m_61143_((Property)f_52726_)).m_122427_());
        worldIn.m_5898_(player, (Boolean)state.m_61143_((Property)f_52727_) != false ? 1005 : 1011, pos, 0);
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        int count = this.removeGate(worldIn, pos, ((Direction)state.m_61143_((Property)f_52726_)).m_122427_());
        for (int i = 0; i < count; ++i) {
            Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
        }
    }

    public int removeGate(Level world, BlockPos startPos, Direction facing) {
        BlockPos current;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((BlockGetter)world, facing, startPos);
        int amount = 0;
        for (int hor = 0; hor < this.maxWidth && world.m_8055_(current = lowerLeftCorner.m_5484_(facing, hor)).m_60734_() == this; ++hor) {
            BlockPos currentPos;
            for (int vert = 0; vert < this.maxHeight && world.m_8055_(currentPos = current.m_6630_(vert)).m_60734_() == this; ++vert) {
                ++amount;
                world.m_7731_(currentPos, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        return amount;
    }

    @Deprecated
    public float getBlockHardness(BlockState blockState, BlockGetter worldIn, BlockPos pos) {
        BlockPos hPos;
        if (worldIn == null) {
            return 10.0f;
        }
        Direction facing = ((Direction)blockState.m_61143_((Property)f_52726_)).m_122427_();
        BlockPos start = this.findLowerLeftCorner(worldIn, facing, pos);
        int count = 0;
        for (int hor = 0; hor < this.maxWidth && worldIn.m_8055_(hPos = start.m_5484_(facing, hor)).m_60734_() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = worldIn.m_8055_(worldPos = hPos.m_7918_(0, vert, 0))).m_60734_() == this; ++vert) {
                ++count;
            }
        }
        return (float)count * this.hardness;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos tPos = pos.m_7918_(-1, -1, -1);
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = 0; z < 3; ++z) {
                    if (worldIn.m_8055_(tPos.m_7918_(x, y, z)).m_60734_() != this) continue;
                    return false;
                }
            }
        }
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        return blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        int hor;
        Direction facing = ((Direction)state.m_61143_((Property)f_52726_)).m_122427_();
        this.fillYStates(worldIn, pos, state, stack);
        int canPlace = this.maxWidth - 1;
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.m_8055_(checkPos = pos.m_5484_(facing.m_122424_(), hor))).m_60795_() && canPlace > 0 && worldIn.m_8055_(checkPos.m_121945_(facing.m_122424_())).m_60734_() != this; --canPlace, ++hor) {
            if (stack.m_41613_() > 1) {
                stack.m_41764_(stack.m_41613_() - 1);
                worldIn.m_46597_(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
        if (canPlace <= 0) {
            return;
        }
        for (hor = 1; hor < this.maxWidth && (checkState = worldIn.m_8055_(checkPos = pos.m_5484_(facing, hor))).m_60734_() != this && checkState.m_60795_() && canPlace > 0 && worldIn.m_8055_(checkPos.m_121945_(facing)).m_60734_() != this; --canPlace, ++hor) {
            if (stack.m_41613_() > 1) {
                stack.m_41764_(stack.m_41613_() - 1);
                worldIn.m_46597_(checkPos, state);
            }
            this.fillYStates(worldIn, checkPos, state, stack);
        }
    }

    private void fillYStates(Level world, BlockPos base, BlockState state, ItemStack stack) {
        BlockPos checkPos;
        BlockState checkState;
        for (int vert = 1; vert < this.maxHeight && (checkState = world.m_8055_(checkPos = base.m_7918_(0, vert, 0))).m_60795_() && world.m_8055_(checkPos.m_7494_()).m_60734_() != this; ++vert) {
            if (stack.m_41613_() <= 1) continue;
            stack.m_41764_(stack.m_41613_() - 1);
            world.m_46597_(checkPos, state);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShapeForState(state);
    }

    private VoxelShape getShapeForState(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_52726_);
        switch (direction) {
            case EAST: 
            case WEST: {
                return E_W_SHAPE;
            }
        }
        return N_S_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
            return Shapes.m_83040_();
        }
        return this.getShapeForState(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.getShapeForState(state);
    }

    public RenderShape m_7514_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)f_52727_)).booleanValue()) {
            return RenderShape.INVISIBLE;
        }
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52730_, f_52726_, f_52727_, f_52728_, f_52729_, WATERLOGGED});
    }

    private BlockPos findLowerLeftCorner(BlockGetter world, Direction facing, BlockPos blockPos) {
        BlockPos tePos = blockPos;
        for (int vert = 0; vert < this.maxHeight; ++vert) {
            BlockPos tempPos = tePos.m_7918_(0, -vert, 0);
            if (world.m_8055_(tempPos.m_7495_()).m_60734_() == this) continue;
            tePos = tempPos;
            break;
        }
        for (int hor = 0; hor < this.maxWidth; ++hor) {
            if (world.m_8055_(tePos.m_5484_(facing.m_122424_(), hor + 1)).m_60734_() == this) continue;
            tePos = tePos.m_5484_(facing.m_122424_(), hor);
            break;
        }
        return tePos;
    }

    public void m_153165_(@Nullable Entity p_153166_, Level worldIn, BlockState state, BlockPos pos, boolean open) {
        BlockState blockstate = worldIn.m_8055_(pos);
        if (blockstate.m_60734_() == this && (Boolean)blockstate.m_61143_((Property)f_52727_) != open) {
            this.toggleGate(worldIn, pos, ((Direction)blockstate.m_61143_((Property)f_52726_)).m_122427_());
        }
    }

    public void toggleGate(Level world, BlockPos clickedBlock, Direction facing) {
        BlockPos hPos;
        BlockPos lowerLeftCorner = this.findLowerLeftCorner((BlockGetter)world, facing, clickedBlock);
        boolean opening = (Boolean)world.m_8055_(lowerLeftCorner).m_61143_((Property)BlockStateProperties.f_61446_) == false;
        for (int hor = 0; hor < this.maxWidth && world.m_8055_(hPos = lowerLeftCorner.m_5484_(facing, hor)).m_60734_() == this; ++hor) {
            BlockPos worldPos;
            BlockState state;
            for (int vert = 0; vert < this.maxHeight && (state = world.m_8055_(worldPos = hPos.m_7918_(0, vert, 0))).m_60734_() == this; ++vert) {
                if (world.m_8055_(worldPos.m_7494_()).m_60734_() != this) {
                    WorldUtil.setBlockState((LevelAccessor)world, worldPos, (BlockState)state.m_61124_((Property)DoorBlock.f_52728_, (Comparable)(opening ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT)), 2);
                    continue;
                }
                WorldUtil.setBlockState((LevelAccessor)world, worldPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(opening)), 2);
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, @NotNull BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.m_276867_(pos);
        if (powered != (Boolean)state.m_61143_((Property)f_52727_)) {
            this.m_153165_(null, worldIn, state, pos, powered);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)f_52726_, (Comparable)context.m_8125_());
        }
        return null;
    }

    public AbstractBlockGate registerBlock(IForgeRegistry<Block> registry) {
        registry.register(new ResourceLocation("minecolonies", this.name), (Object)this);
        return this;
    }

    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(new ResourceLocation("minecolonies", this.name), (Object)new BlockItem((Block)this, properties));
    }
}

