/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Stack
implements IConcreteDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Stack.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_STACK = "Stack";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_BUILDING_RES = "BuildingRes";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    @NotNull
    private final ItemStack theStack;
    private boolean matchDamage;
    private boolean matchNBT;
    private boolean matchOreDic;
    private int count;
    private int minCount;
    @NotNull
    private ItemStack result;
    private boolean canBeResolvedByBuilding;

    public Stack(@NotNull ItemStack stack) {
        this(stack, true);
    }

    public Stack(@NotNull ItemStack stack, boolean matchDurability) {
        this(stack, matchDurability, true, false, ItemStackUtils.EMPTY, Math.min(stack.m_41613_(), stack.m_41741_()), Math.min(stack.m_41613_(), stack.m_41741_()));
    }

    public Stack(@NotNull ItemStack stack, int count, int minCount) {
        this(stack, count, minCount, true);
    }

    public Stack(@NotNull ItemStorage itemStorage) {
        this(itemStorage.getItemStack(), !itemStorage.ignoreDamageValue(), !itemStorage.ignoreNBT(), false, ItemStackUtils.EMPTY, itemStorage.getAmount(), itemStorage.getAmount());
    }

    public Stack(@NotNull ItemStack stack, int count, int minCount, boolean matchNBT) {
        this(stack, true, matchNBT, false, ItemStackUtils.EMPTY, count, minCount);
    }

    public Stack(@NotNull ItemStack stack, boolean matchDamage, boolean matchNBT, boolean matchOreDic, @NotNull ItemStack result, int count, int minCount) {
        this(stack, matchDamage, matchNBT, matchOreDic, ItemStackUtils.EMPTY, count, minCount, true);
    }

    public Stack(ItemStack stack, boolean matchDamage, boolean matchNBT, boolean matchOreDic, ItemStack result, int count, int minCount, boolean canBeResolvedByBuilding) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            throw new IllegalArgumentException("Cannot deliver Empty Stack.");
        }
        this.theStack = stack.m_41777_();
        this.matchDamage = matchDamage;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
        this.canBeResolvedByBuilding = canBeResolvedByBuilding;
    }

    public static CompoundTag serialize(IFactoryController controller, Stack input) {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_(NBT_STACK, (Tag)input.theStack.serializeNBT());
        compound.m_128379_(NBT_MATCHMETA, input.matchDamage);
        compound.m_128379_(NBT_MATCHNBT, input.matchNBT);
        compound.m_128379_(NBT_MATCHOREDIC, input.matchOreDic);
        compound.m_128379_(NBT_BUILDING_RES, input.canBeResolvedByBuilding);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            compound.m_128365_(NBT_RESULT, (Tag)input.result.serializeNBT());
        }
        compound.m_128405_(NBT_COUNT, input.getCount());
        compound.m_128405_(NBT_MINCOUNT, input.getMinimumCount());
        return compound;
    }

    public static Stack deserialize(IFactoryController controller, CompoundTag compound) {
        int count;
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.m_128469_(NBT_STACK));
        boolean matchMeta = compound.m_128471_(NBT_MATCHMETA);
        boolean matchNBT = compound.m_128471_(NBT_MATCHNBT);
        boolean matchOreDic = compound.m_128471_(NBT_MATCHOREDIC);
        boolean canBeResolved = compound.m_128441_(NBT_BUILDING_RES) ? compound.m_128471_(NBT_BUILDING_RES) : true;
        ItemStack result = compound.m_128441_(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.m_128469_(NBT_RESULT)) : ItemStackUtils.EMPTY;
        int minCount = count = compound.m_128451_("size");
        if (compound.m_128441_(NBT_COUNT)) {
            count = compound.m_128451_(NBT_COUNT);
            minCount = compound.m_128451_(NBT_MINCOUNT);
        }
        return new Stack(stack, matchMeta, matchNBT, matchOreDic, result, count, minCount, canBeResolved);
    }

    public static void serialize(IFactoryController controller, FriendlyByteBuf buffer, Stack input) {
        buffer.m_130055_(input.theStack);
        buffer.writeBoolean(input.matchDamage);
        buffer.writeBoolean(input.matchNBT);
        buffer.writeBoolean(input.matchOreDic);
        buffer.writeBoolean(input.canBeResolvedByBuilding);
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.m_130055_(input.result);
        }
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
    }

    public static Stack deserialize(IFactoryController controller, FriendlyByteBuf buffer) {
        ItemStack stack = buffer.m_130267_();
        boolean matchMeta = buffer.readBoolean();
        boolean matchNBT = buffer.readBoolean();
        boolean matchOreDic = buffer.readBoolean();
        boolean canBeResolved = buffer.readBoolean();
        ItemStack result = buffer.readBoolean() ? buffer.m_130267_() : ItemStack.f_41583_;
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new Stack(stack, matchMeta, matchNBT, matchOreDic, result, count, minCount, canBeResolved);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic && !Collections.disjoint(stack.m_204131_().toList(), this.theStack.m_204131_().toList())) {
            return true;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), stack, this.matchDamage, this.matchNBT);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @NotNull
    public ItemStack getStack() {
        return this.theStack;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    public boolean matchNBT() {
        return this.matchNBT;
    }

    public boolean matchDamage() {
        return this.matchDamage;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Stack(this.theStack, this.matchDamage, this.matchNBT, this.matchOreDic, this.result, newCount, this.minCount);
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack stack1 = (Stack)o;
        if (this.matchDamage != stack1.matchDamage) {
            return false;
        }
        if (this.canBeResolvedByBuilding != stack1.canBeResolvedByBuilding) {
            return false;
        }
        if (this.matchNBT != stack1.matchNBT) {
            return false;
        }
        if (this.matchOreDic != stack1.matchOreDic) {
            return false;
        }
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), stack1.getStack()).booleanValue()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), stack1.getResult());
    }

    public int hashCode() {
        int result1 = this.getStack().hashCode();
        result1 = 31 * result1 + (this.matchDamage ? 1 : 0);
        result1 = 31 * result1 + (this.matchNBT ? 1 : 0);
        result1 = 31 * result1 + (this.matchOreDic ? 1 : 0);
        result1 = 31 * result1 + (this.canBeResolvedByBuilding ? 1 : 0);
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public boolean canBeResolvedByBuilding() {
        return this.canBeResolvedByBuilding;
    }

    public void setCanBeResolvedByBuilding(boolean canBeResolvedByBuilding) {
        this.canBeResolvedByBuilding = canBeResolvedByBuilding;
    }

    @Override
    public List<ItemStack> getRequestedItems() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.theStack});
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

