/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesMinecart
extends Minecart {
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> MATRIX = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), entry -> {
        Vec3i westVec = Direction.WEST.m_122436_();
        Vec3i eastVec = Direction.EAST.m_122436_();
        Vec3i northVec = Direction.NORTH.m_122436_();
        Vec3i southVec = Direction.SOUTH.m_122436_();
        entry.put(RailShape.NORTH_SOUTH, Pair.of((Object)northVec, (Object)southVec));
        entry.put(RailShape.EAST_WEST, Pair.of((Object)westVec, (Object)eastVec));
        entry.put(RailShape.ASCENDING_EAST, Pair.of((Object)westVec.m_7495_(), (Object)eastVec));
        entry.put(RailShape.ASCENDING_WEST, Pair.of((Object)westVec, (Object)eastVec.m_7495_()));
        entry.put(RailShape.ASCENDING_NORTH, Pair.of((Object)northVec, (Object)southVec.m_7495_()));
        entry.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northVec.m_7495_(), (Object)southVec));
        entry.put(RailShape.SOUTH_EAST, Pair.of((Object)southVec, (Object)eastVec));
        entry.put(RailShape.SOUTH_WEST, Pair.of((Object)southVec, (Object)westVec));
        entry.put(RailShape.NORTH_WEST, Pair.of((Object)northVec, (Object)westVec));
        entry.put(RailShape.NORTH_EAST, Pair.of((Object)northVec, (Object)eastVec));
    });

    public MinecoloniesMinecart(EntityType<?> type, Level world) {
        super(type, world);
    }

    protected void m_6401_(BlockPos pos, BlockState state) {
        double tempVeloc;
        Vec3 tempMot;
        double xzDif;
        this.f_19789_ = 0.0f;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        Vec3 posVec = this.m_38179_(x, y, z);
        y = pos.m_123342_();
        boolean isPowered = false;
        boolean flag = false;
        BaseRailBlock abstractrailblock = (BaseRailBlock)state.m_60734_();
        if (abstractrailblock instanceof PoweredRailBlock && !((PoweredRailBlock)abstractrailblock).isActivatorRail()) {
            isPowered = (Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_);
            flag = !isPowered;
        }
        RailShape railshape = ((BaseRailBlock)state.m_60734_()).getRailDirection(state, (BlockGetter)this.m_9236_(), pos, (AbstractMinecart)this);
        switch (railshape) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                y += 1.0;
                break;
            }
        }
        Vec3 motion = this.m_20184_();
        Pair<Vec3i, Vec3i> pair = MinecoloniesMinecart.getShapeMatrix(railshape);
        Vec3i vecIn = (Vec3i)pair.getFirst();
        Vec3i vecOut = (Vec3i)pair.getSecond();
        double xDif = vecOut.m_123341_() - vecIn.m_123341_();
        double zDif = vecOut.m_123343_() - vecIn.m_123343_();
        double difSq = Math.sqrt(xDif * xDif + zDif * zDif);
        double difMotion = motion.f_82479_ * xDif + motion.f_82481_ * zDif;
        if (difMotion < 0.0) {
            xDif = -xDif;
            zDif = -zDif;
        }
        double veloc = Math.min(2.0, Math.sqrt(motion.m_165925_()));
        motion = new Vec3(veloc * xDif / difSq, motion.f_82480_, veloc * zDif / difSq);
        this.m_20256_(motion);
        if (flag && this.shouldDoRailFunctions()) {
            double tempMot2 = Math.sqrt(this.m_20184_().m_165925_());
            if (tempMot2 < 0.03) {
                this.m_20256_(Vec3.f_82478_);
            } else {
                this.m_20256_(this.m_20184_().m_82542_(0.5, 0.0, 0.5));
            }
        }
        double xInDif = (double)pos.m_123341_() + 0.5 + (double)vecIn.m_123341_() * 0.5;
        double zInDif = (double)pos.m_123343_() + 0.5 + (double)vecIn.m_123343_() * 0.5;
        double xOutDif = (double)pos.m_123341_() + 0.5 + (double)vecOut.m_123341_() * 0.5;
        double zOutDif = (double)pos.m_123343_() + 0.5 + (double)vecOut.m_123343_() * 0.5;
        xDif = xOutDif - xInDif;
        zDif = zOutDif - zInDif;
        if (xDif == 0.0) {
            xzDif = z - (double)pos.m_123343_();
        } else if (zDif == 0.0) {
            xzDif = x - (double)pos.m_123341_();
        } else {
            double d15 = x - xInDif;
            double d16 = z - zInDif;
            xzDif = (d15 * xDif + d16 * zDif) * 2.0;
        }
        x = xInDif + xDif * xzDif;
        z = zInDif + zDif * xzDif;
        this.m_6034_(x, y, z);
        this.moveMinecartOnRail(pos);
        if (vecIn.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - pos.m_123341_() == vecIn.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - pos.m_123343_() == vecIn.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vecIn.m_123342_(), this.m_20189_());
        } else if (vecOut.m_123342_() != 0 && Mth.m_14107_((double)this.m_20185_()) - pos.m_123341_() == vecOut.m_123341_() && Mth.m_14107_((double)this.m_20189_()) - pos.m_123343_() == vecOut.m_123343_()) {
            this.m_6034_(this.m_20185_(), this.m_20186_() + (double)vecOut.m_123342_(), this.m_20189_());
        }
        this.m_7114_();
        Vec3 newPos = this.m_38179_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        if (newPos != null && posVec != null) {
            double yMot = (posVec.f_82480_ - newPos.f_82480_) * 0.05;
            tempMot = this.m_20184_();
            tempVeloc = Math.sqrt(tempMot.m_165925_());
            if (tempVeloc > 0.0) {
                this.m_20256_(tempMot.m_82542_((tempVeloc + yMot) / tempVeloc, 1.0, (tempVeloc + yMot) / tempVeloc));
            }
            this.m_6034_(this.m_20185_(), newPos.f_82480_, this.m_20189_());
        }
        int xFloor = Mth.m_14107_((double)this.m_20185_());
        int zFloor = Mth.m_14107_((double)this.m_20189_());
        if (xFloor != pos.m_123341_() || zFloor != pos.m_123343_()) {
            tempMot = this.m_20184_();
            double temoVeloc = Math.sqrt(tempMot.m_165925_());
            this.m_20334_(temoVeloc * (double)(xFloor - pos.m_123341_()), tempMot.f_82480_, temoVeloc * (double)(zFloor - pos.m_123343_()));
        }
        if (this.shouldDoRailFunctions()) {
            ((BaseRailBlock)state.m_60734_()).onMinecartPass(state, this.m_9236_(), pos, (AbstractMinecart)this);
        }
        if (isPowered && this.shouldDoRailFunctions()) {
            tempMot = this.m_20184_();
            tempVeloc = Math.sqrt(tempMot.m_165925_());
            if (tempVeloc > 0.01) {
                this.m_20256_(tempMot.m_82520_(tempMot.f_82479_ / tempVeloc * 0.06, 0.0, tempMot.f_82481_ / tempVeloc * 0.06));
            } else {
                Vec3 mot = this.m_20184_();
                double tempX = mot.f_82479_;
                double tempZ = mot.f_82481_;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isNormalCube(pos.m_122024_())) {
                        tempX = 0.02;
                    } else if (this.isNormalCube(pos.m_122029_())) {
                        tempX = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isNormalCube(pos.m_122012_())) {
                        tempZ = 0.02;
                    } else if (this.isNormalCube(pos.m_122019_())) {
                        tempZ = -0.02;
                    }
                }
                this.m_20334_(tempX, mot.f_82480_, tempZ);
            }
        }
    }

    public void m_7617_(DamageSource source) {
        this.m_6074_();
    }

    private boolean isNormalCube(BlockPos pos) {
        return this.m_9236_().m_8055_(pos).m_60796_((BlockGetter)this.m_9236_(), pos);
    }

    private static Pair<Vec3i, Vec3i> getShapeMatrix(RailShape p_226573_0_) {
        return MATRIX.get(p_226573_0_);
    }

    public InteractionResult m_6096_(Player p_184230_1_, InteractionHand p_184230_2_) {
        return InteractionResult.FAIL;
    }

    public boolean m_6087_() {
        return false;
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public void m_7334_(@NotNull Entity entityIn) {
    }

    public void m_6123_(Player entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_7337_(Entity p_38168_) {
        return false;
    }

    public void m_8119_() {
        if (this.m_38176_() > 0) {
            this.m_38154_(this.m_38176_() - 1);
        }
        if (this.m_38169_() > 0.0f) {
            this.m_38109_(this.m_38169_() - 1.0f);
        }
        this.m_146871_();
        this.m_20157_();
        if (this.m_9236_().f_46443_) {
            if (this.f_38070_ > 0) {
                double d5 = this.m_20185_() + (this.f_38071_ - this.m_20185_()) / (double)this.f_38070_;
                double d6 = this.m_20186_() + (this.f_38072_ - this.m_20186_()) / (double)this.f_38070_;
                double d7 = this.m_20189_() + (this.f_38073_ - this.m_20189_()) / (double)this.f_38070_;
                double d2 = Mth.m_14175_((double)(this.f_38074_ - (double)this.m_146908_()));
                this.m_146922_(this.m_146908_() + (float)d2 / (float)this.f_38070_);
                this.m_146926_(this.m_146909_() + (float)(this.f_38075_ - (double)this.m_146909_()) / (float)this.f_38070_);
                --this.f_38070_;
                this.m_6034_(d5, d6, d7);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            } else {
                this.m_20090_();
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
        } else {
            double d4;
            if (!this.m_20068_()) {
                double d0 = this.m_20069_() ? -0.005 : -0.04;
                this.m_20256_(this.m_20184_().m_82520_(0.0, d0, 0.0));
            }
            int k = Mth.m_14107_((double)this.m_20185_());
            int i = Mth.m_14107_((double)this.m_20186_());
            int j = Mth.m_14107_((double)this.m_20189_());
            if (this.m_9236_().m_8055_(new BlockPos(k, i - 1, j)).m_204336_(BlockTags.f_13034_)) {
                --i;
            }
            BlockPos blockpos = new BlockPos(k, i, j);
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (this.canUseRail() && BaseRailBlock.m_49416_((BlockState)blockstate)) {
                this.m_6401_(blockpos, blockstate);
                if (blockstate.m_60734_() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.m_60734_()).isActivatorRail()) {
                    this.m_6025_(k, i, j, (Boolean)blockstate.m_61143_((Property)PoweredRailBlock.f_55215_));
                }
            } else {
                this.m_38163_();
            }
            this.m_20101_();
            this.m_146926_(0.0f);
            double d1 = this.f_19854_ - this.m_20185_();
            double d3 = this.f_19856_ - this.m_20189_();
            if (d1 * d1 + d3 * d3 > 0.001) {
                this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI));
                if (this.f_38068_) {
                    this.m_146922_(this.m_146908_() + 180.0f);
                }
            }
            if ((d4 = (double)Mth.m_14177_((float)(this.m_146908_() - this.f_19859_))) < -170.0 || d4 >= 170.0) {
                this.m_146922_(this.m_146908_() + 180.0f);
                this.f_38068_ = !this.f_38068_;
            }
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.m_20073_();
            if (this.m_20077_()) {
                this.m_20093_();
                this.f_19789_ *= 0.5f;
            }
            this.f_19803_ = false;
        }
        if (this.f_19797_ % 20 == 19 && this.m_20197_().isEmpty()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

