/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.util.Log;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class HappinessRegistry {
    public static ResourceLocation STATIC_MODIFIER = new ResourceLocation("minecolonies", "static");
    public static ResourceLocation EXPIRATION_MODIFIER = new ResourceLocation("minecolonies", "expiration");
    public static ResourceLocation TIME_PERIOD_MODIFIER = new ResourceLocation("minecolonies", "time");
    public static RegistryObject<HappinessFactorTypeEntry> staticHappinessModifier;
    public static RegistryObject<HappinessFactorTypeEntry> expirationBasedHappinessModifier;
    public static RegistryObject<HappinessFactorTypeEntry> timeBasedHappinessModifier;
    public static ResourceLocation SCHOOL_FUNCTION;
    public static ResourceLocation SECURITY_FUNCTION;
    public static ResourceLocation SOCIAL_FUNCTION;
    public static ResourceLocation SATURATION_FUNCTION;
    public static ResourceLocation MYSTICAL_SITE_FUNCTION;
    public static ResourceLocation HOUSING_FUNCTION;
    public static ResourceLocation UNEMPLOYMENT_FUNCTION;
    public static ResourceLocation HEALTH_FUNCTION;
    public static ResourceLocation IDLEATJOB_FUNCTION;
    public static ResourceLocation SLEPTTONIGHT_FUNCTION;
    public static RegistryObject<HappinessFunctionEntry> schoolFunction;
    public static RegistryObject<HappinessFunctionEntry> securityFunction;
    public static RegistryObject<HappinessFunctionEntry> socialFunction;
    public static RegistryObject<HappinessFunctionEntry> saturationFunction;
    public static RegistryObject<HappinessFunctionEntry> mysticalSiteFunction;
    public static RegistryObject<HappinessFunctionEntry> housingFunction;
    public static RegistryObject<HappinessFunctionEntry> unemploymentFunction;
    public static RegistryObject<HappinessFunctionEntry> healthFunction;
    public static RegistryObject<HappinessFunctionEntry> idleatjobFunction;
    public static RegistryObject<HappinessFunctionEntry> sleptTonightFunction;

    static IForgeRegistry<HappinessFactorTypeEntry> getHappinessTypeRegistry() {
        return IMinecoloniesAPI.getInstance().getHappinessTypeRegistry();
    }

    static IForgeRegistry<HappinessFunctionEntry> getHappinessFunctionRegistry() {
        return IMinecoloniesAPI.getInstance().getHappinessFunctionRegistry();
    }

    public static IHappinessModifier loadFrom(@NotNull CompoundTag compound) {
        ResourceLocation modifierType = compound.m_128441_("modifier") ? new ResourceLocation(compound.m_128461_("modifier")) : new ResourceLocation("minecolonies", "null");
        IHappinessModifier modifier = ((HappinessFactorTypeEntry)HappinessRegistry.getHappinessTypeRegistry().getValue(modifierType)).create();
        if (modifier != null) {
            try {
                modifier.read(compound);
            }
            catch (RuntimeException ex) {
                Log.getLogger().error(String.format("A Happiness Modifier %s has thrown an exception during loading, its state cannot be restored. Report this to the mod author", modifierType), (Throwable)ex);
                return null;
            }
        } else {
            Log.getLogger().warn(String.format("Unknown Happiness Modifier type '%s' or missing constructor of proper format.", modifierType));
        }
        return modifier;
    }

    static {
        SCHOOL_FUNCTION = new ResourceLocation("minecolonies", "school");
        SECURITY_FUNCTION = new ResourceLocation("minecolonies", "security");
        SOCIAL_FUNCTION = new ResourceLocation("minecolonies", "social");
        SATURATION_FUNCTION = new ResourceLocation("minecolonies", "saturation");
        MYSTICAL_SITE_FUNCTION = new ResourceLocation("minecolonies", "mystical");
        HOUSING_FUNCTION = new ResourceLocation("minecolonies", "housing");
        UNEMPLOYMENT_FUNCTION = new ResourceLocation("minecolonies", "unemployment");
        HEALTH_FUNCTION = new ResourceLocation("minecolonies", "health");
        IDLEATJOB_FUNCTION = new ResourceLocation("minecolonies", "idleatjob");
        SLEPTTONIGHT_FUNCTION = new ResourceLocation("minecolonies", "slepttonight");
    }

    public static class HappinessFactorTypeEntry {
        private final Supplier<IHappinessModifier> supplier;

        public HappinessFactorTypeEntry(Supplier<IHappinessModifier> productionFunction) {
            this.supplier = productionFunction;
        }

        public IHappinessModifier create() {
            return this.supplier.get();
        }
    }

    public static class HappinessFunctionEntry {
        private final Function<ICitizenData, Double> doubleSupplier;

        public HappinessFunctionEntry(Function<ICitizenData, Double> doubleSupplier) {
            this.doubleSupplier = doubleSupplier;
        }

        public Function<ICitizenData, Double> getDoubleSupplier() {
            return this.doubleSupplier;
        }
    }
}

