/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Optional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.m_41741_()) continue;
            craftingCount = Math.max(ingredient.m_41741_(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(@NotNull int count, @NotNull IRecipeStorage storage) {
        return (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
    }

    public static OptionalPredicate<ItemStack> getProductValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            TagKey<Item> excludedProducts = ModTags.crafterProductExclusions.get(crafterJobName);
            if (excludedProducts != null && stack.m_204117_(excludedProducts)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedProducts = ModTags.crafterProduct.get(crafterJobName);
            if (allowedProducts != null && stack.m_204117_(allowedProducts)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName) {
        return CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName, false);
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName, boolean includeDoRules) {
        return stack -> {
            TagKey<Item> includedDoIngredients;
            if (includeDoRules && (includedDoIngredients = ModTags.crafterDoIngredient.get(crafterJobName)) != null && stack.m_204117_(includedDoIngredients)) {
                return Optional.of(true);
            }
            TagKey<Item> excludedIngredients = ModTags.crafterIngredientExclusions.get(crafterJobName);
            if (excludedIngredients != null && stack.m_204117_(excludedIngredients)) {
                return Optional.of(false);
            }
            TagKey<Item> allowedIngredients = ModTags.crafterIngredient.get(crafterJobName);
            if (allowedIngredients != null && stack.m_204117_(allowedIngredients)) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static Optional<Boolean> isRecipeCompatibleBasedOnTags(@NotNull IGenericRecipe recipe, @NotNull String crafterJobName) {
        return OptionalPredicate.combine(recipe.matchesOutput(CraftingUtils.getProductValidatorBasedOnTags(crafterJobName)), () -> recipe.matchesInput(CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName)));
    }
}

