/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityNamedGraveRenderer
implements BlockEntityRenderer<TileEntityNamedGrave> {
    private static final int BASIC_ROTATION = 90;
    private static final int ROTATE_EAST = 1;
    private static final int ROTATE_NORTH = 2;
    private static final int ROTATE_WEST = 3;

    public TileEntityNamedGraveRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull TileEntityNamedGrave tileEntity, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state;
        matrixStack.m_85836_();
        if (tileEntity != null && (state = tileEntity.m_58904_().m_8055_(tileEntity.m_58899_())).m_60734_() == ModBlocks.blockNamedGrave) {
            Direction facing = (Direction)state.m_61143_((Property)AbstractBlockMinecoloniesDefault.FACING);
            switch (facing) {
                case NORTH: {
                    matrixStack.m_252880_(0.5f, 1.18f, 0.48f);
                    matrixStack.m_85841_(0.006f, -0.006f, 0.006f);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    break;
                }
                case SOUTH: {
                    matrixStack.m_252880_(0.5f, 1.18f, 0.54f);
                    matrixStack.m_85841_(0.006f, -0.006f, 0.006f);
                    break;
                }
                case EAST: {
                    matrixStack.m_252880_(0.54f, 1.18f, 0.5f);
                    matrixStack.m_85841_(0.006f, -0.006f, 0.006f);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    break;
                }
                case WEST: {
                    matrixStack.m_252880_(0.48f, 1.18f, 0.5f);
                    matrixStack.m_85841_(0.006f, -0.006f, 0.006f);
                    matrixStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                }
            }
            if (tileEntity.getTextLines().isEmpty()) {
                this.renderText(matrixStack, buffer, combinedLight, "Unknown Citizen", 0);
            } else {
                for (int i = 0; i < tileEntity.getTextLines().size(); ++i) {
                    this.renderText(matrixStack, buffer, combinedLight, tileEntity.getTextLines().get(i), i);
                }
            }
        }
        matrixStack.m_85849_();
    }

    private void renderText(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, String text, int line) {
        FormattedCharSequence iReorderingProcessor;
        int maxSize = 20;
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        if ((iReorderingProcessor = FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_)) != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            float x = -fontRenderer.m_92724_(iReorderingProcessor) / 2;
            fontRenderer.m_272191_(iReorderingProcessor, x, (float)line * 10.0f, -589505536, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        }
    }

    public boolean shouldRenderOffScreen(TileEntityNamedGrave tileEntityMBE21) {
        return false;
    }
}

