/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.modules.IFieldModule;
import com.minecolonies.api.colony.fields.plantation.IPlantationModule;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.client.gui.modules.PlantationFieldsModuleWindow;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.FieldsModule;
import com.minecolonies.coremod.colony.buildings.moduleviews.FieldsModuleView;
import com.minecolonies.coremod.colony.fields.PlantationField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingPlantation
extends AbstractBuilding {
    private static final String PLANTATION = "plantation";
    private boolean triggerFieldMigration = false;

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public void onPlacement() {
        super.onPlacement();
        this.updateFields();
    }

    private void updateFields() {
        this.updateField((FieldRegistries.FieldEntry)FieldRegistries.plantationSugarCaneField.get());
        this.updateField((FieldRegistries.FieldEntry)FieldRegistries.plantationCactusField.get());
        this.updateField((FieldRegistries.FieldEntry)FieldRegistries.plantationBambooField.get());
    }

    private void updateField(FieldRegistries.FieldEntry type) {
        PlantationField plantationField = PlantationField.create(type, this.getPosition());
        List<BlockPos> workingPositions = plantationField.getModule().getValidWorkingPositions(this.colony.getWorld(), this.getLocationsFromTag(plantationField.getModule().getWorkTag()));
        if (workingPositions.isEmpty()) {
            this.colony.getBuildingManager().removeField(field -> field.equals(plantationField));
            return;
        }
        if (this.colony.getBuildingManager().addField(plantationField)) {
            plantationField.setWorkingPositions(workingPositions);
        } else {
            IField iField;
            Optional<IField> existingField = this.colony.getBuildingManager().getField(field -> field.equals(plantationField));
            if (existingField.isPresent() && (iField = existingField.get()) instanceof PlantationField) {
                PlantationField existingPlantationField = (PlantationField)iField;
                existingPlantationField.setWorkingPositions(workingPositions);
            }
        }
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("plantGround")) {
            this.triggerFieldMigration = true;
        }
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        this.updateFields();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = super.getRequiredItemsAndAmount();
        for (FieldsModule module : this.getModules(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                if (!(field instanceof PlantationField)) continue;
                PlantationField plantationField = (PlantationField)field;
                IPlantationModule plantationModule = (IPlantationModule)plantationField.getFirstModuleOccurance(IPlantationModule.class);
                toKeep.put(stack -> ItemStack.m_41656_((ItemStack)new ItemStack((ItemLike)plantationModule.getItem()), (ItemStack)stack), (Tuple<Integer, Boolean>)new Tuple((Object)plantationModule.getPlantsToRequest(), (Object)true));
            }
        }
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (!super.canEat(stack)) {
            return false;
        }
        for (FieldsModule module : this.getModules(FieldsModule.class)) {
            for (IField field : module.getOwnedFields()) {
                PlantationField plantationField;
                IPlantationModule plantationModule;
                if (!(field instanceof PlantationField) || !ItemStackUtils.compareItemStacksIgnoreStackSize(new ItemStack((ItemLike)(plantationModule = (IPlantationModule)(plantationField = (PlantationField)field).getFirstModuleOccurance(IPlantationModule.class)).getItem()), stack).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        super.setTileEntity(te);
        if (this.triggerFieldMigration) {
            this.updateFields();
            this.triggerFieldMigration = false;
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, BuildingPlantation.PLANTATION);
            return isRecipeAllowed.orElse(false);
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            for (FieldRegistries.FieldEntry type : FieldRegistries.getFieldRegistry().getValues()) {
                type.getFieldModuleProducers().stream().map(m -> (IFieldModule)m.apply(null)).filter(IPlantationModule.class::isInstance).map(m -> (IPlantationModule)m).findFirst().ifPresent(module -> recipes.add(new GenericRecipe(null, new ItemStack((ItemLike)module.getItem()), Collections.emptyList(), List.of(module.getRequiredItemsForOperation()), 1, Blocks.f_50016_, null, module.getRequiredTool(), Collections.emptyList(), -1)));
            }
            return recipes;
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(BuildingPlantation.PLANTATION).combine(super.getIngredientValidator());
        }
    }

    public static class PlantationFieldsModuleView
    extends FieldsModuleView {
        private int maxConcurrentPlants = 0;

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            this.maxConcurrentPlants = buf.readInt();
        }

        @Override
        protected boolean canAssignFieldOverride(IField field) {
            return this.getCurrentPlantsPlusField(field) <= this.maxConcurrentPlants && this.hasRequiredResearchForField(field);
        }

        @Override
        protected List<IField> getFieldsInColony() {
            return this.getColony().getFields(field -> field.hasModule(IPlantationModule.class));
        }

        @Override
        @Nullable
        public MutableComponent getFieldWarningTooltip(IField field) {
            MutableComponent result = super.getFieldWarningTooltip(field);
            if (result != null) {
                return result;
            }
            if (this.getCurrentPlantsPlusField(field) > this.maxConcurrentPlants) {
                return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.plantationfields.plantcount.reached");
            }
            if (!this.hasRequiredResearchForField(field)) {
                return Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.fields.plantation.research");
            }
            return null;
        }

        private int getCurrentPlantsPlusField(IField extraField) {
            Set plants = this.getOwnedFields().stream().map(field -> field.getFirstModuleOccurance(IPlantationModule.class)).collect(Collectors.toSet());
            plants.add(extraField.getFirstModuleOccurance(IPlantationModule.class));
            return plants.size();
        }

        private boolean hasRequiredResearchForField(IField field) {
            if (field instanceof PlantationField) {
                PlantationField plantationField = (PlantationField)field;
                IPlantationModule plantationModule = (IPlantationModule)plantationField.getFirstModuleOccurance(IPlantationModule.class);
                if (plantationModule.getRequiredResearchEffect() != null) {
                    return this.getColony().getResearchManager().getResearchEffects().getEffectStrength(plantationModule.getRequiredResearchEffect()) > 0.0;
                }
                return true;
            }
            return false;
        }

        public int getCurrentPlants() {
            return this.getOwnedFields().stream().map(field -> field.getFirstModuleOccurance(IPlantationModule.class)).collect(Collectors.toSet()).size();
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BOWindow getWindow() {
            return new PlantationFieldsModuleWindow(this.buildingView, this);
        }

        public int getMaxConcurrentPlants() {
            return this.maxConcurrentPlants;
        }
    }

    public static class PlantationFieldsModule
    extends FieldsModule {
        @Override
        public void serializeToView(@NotNull FriendlyByteBuf buf) {
            super.serializeToView(buf);
            buf.writeInt(this.getMaxConcurrentPlants());
        }

        public int getMaxConcurrentPlants() {
            return (int)Math.ceil((double)this.building.getBuildingLevel() / 2.0);
        }

        @Override
        protected int getMaxFieldCount() {
            int allowedPlants = (int)Math.ceil((double)this.building.getBuildingLevel() / 2.0);
            return this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.PLANTATION_LARGE) > 0.0 ? allowedPlants + 1 : allowedPlants;
        }

        @Override
        public Class<?> getExpectedFieldType() {
            return PlantationField.class;
        }

        @Override
        @NotNull
        public List<IField> getFields() {
            return this.building.getColony().getBuildingManager().getFields(field -> field.hasModule(IPlantationModule.class));
        }

        @Override
        public boolean canAssignFieldOverride(IField field) {
            return this.getCurrentPlantsPlusField(field) <= this.getMaxConcurrentPlants() && this.hasRequiredResearchForField(field);
        }

        @Override
        protected int getFieldCheckTimeoutSeconds() {
            return 60;
        }

        private int getCurrentPlantsPlusField(IField extraField) {
            Set plants = this.getOwnedFields().stream().map(field -> field.getFirstModuleOccurance(IPlantationModule.class)).collect(Collectors.toSet());
            plants.add(extraField.getFirstModuleOccurance(IPlantationModule.class));
            return plants.size();
        }

        private boolean hasRequiredResearchForField(IField field) {
            if (field instanceof PlantationField) {
                PlantationField plantationField = (PlantationField)field;
                IPlantationModule plantationModule = (IPlantationModule)plantationField.getFirstModuleOccurance(IPlantationModule.class);
                if (plantationModule.getRequiredResearchEffect() != null) {
                    return this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(plantationModule.getRequiredResearchEffect()) > 0.0;
                }
                return true;
            }
            return false;
        }
    }
}

