/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventDescriptionTypeRegistryEntry;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.townhall.WindowMainPage;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;

public class BuildingTownHall
extends AbstractBuilding
implements ITownHall {
    private static final String TOWN_HALL = "townhall";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final LinkedList<PermissionEvent> permissionEvents = new LinkedList();

    public BuildingTownHall(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return TOWN_HALL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void addPermissionEvent(PermissionEvent event) {
        if (!this.permissionEvents.contains(event)) {
            if (this.permissionEvents.size() >= 100) {
                this.permissionEvents.removeFirst();
            }
            this.permissionEvents.add(event);
            this.markDirty();
        }
    }

    @Override
    public void removePermissionEvents(@NotNull UUID id) {
        if (this.permissionEvents.removeIf(e -> id.equals(e.getId()))) {
            this.markDirty();
        }
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(((Boolean)MineColonies.getConfig().getServer().canPlayerUseAllyTHTeleport.get()).booleanValue());
        buf.writeInt(this.permissionEvents.size());
        for (PermissionEvent permissionEvent : this.permissionEvents) {
            permissionEvent.serialize(buf);
        }
        List<IColonyEventDescription> colonyEvents = this.colony.getEventDescriptionManager().getEventDescriptions();
        buf.writeInt(colonyEvents.size());
        for (IColonyEventDescription iColonyEventDescription : colonyEvents) {
            buf.m_130070_(iColonyEventDescription.getEventTypeId().m_135815_());
            iColonyEventDescription.serialize(buf);
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (ItemStack stack : InventoryUtils.getBuildingInventory(this)) {
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42573_) continue;
            arrayList.add(stack);
        }
        Level level = this.colony.getWorld();
        int validMapCount = 0;
        for (ItemStack stack : arrayList) {
            if (MapItem.m_42853_((ItemStack)stack, (Level)level) == null) continue;
            ++validMapCount;
        }
        buf.writeInt(validMapCount);
        for (ItemStack stack : arrayList) {
            MapItemSavedData mapData = MapItem.m_42853_((ItemStack)stack, (Level)level);
            if (mapData == null) continue;
            buf.m_130079_(mapData.m_7176_(new CompoundTag()));
        }
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView
    implements ITownHallView {
        private final List<PermissionEvent> permissionEvents = new LinkedList<PermissionEvent>();
        private final List<IColonyEventDescription> colonyEvents = new LinkedList<IColonyEventDescription>();
        private boolean canPlayerUseTP = false;
        private List<MapItemSavedData> mapDataList = new ArrayList<MapItemSavedData>();

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowMainPage(this);
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            this.canPlayerUseTP = buf.readBoolean();
            int permissionEventsSize = buf.readInt();
            this.permissionEvents.clear();
            for (int i = 0; i < permissionEventsSize; ++i) {
                this.permissionEvents.add(new PermissionEvent(buf));
            }
            this.colonyEvents.clear();
            int colonyEventsSize = buf.readInt();
            for (int i = 0; i < colonyEventsSize; ++i) {
                ResourceLocation eventTypeID = new ResourceLocation("minecolonies", buf.m_130277_());
                ColonyEventDescriptionTypeRegistryEntry registryEntry = (ColonyEventDescriptionTypeRegistryEntry)MinecoloniesAPIProxy.getInstance().getColonyEventDescriptionRegistry().getValue(eventTypeID);
                if (registryEntry == null) {
                    Log.getLogger().warn("Event is missing registryEntry!:" + eventTypeID.m_135815_());
                    continue;
                }
                this.colonyEvents.add(registryEntry.deserializeEventDescriptionFromFriendlyByteBuf(buf));
            }
            int size = buf.readInt();
            this.mapDataList.clear();
            for (int i = 0; i < size; ++i) {
                MapItemSavedData mapData = MapItemSavedData.m_164807_((CompoundTag)buf.m_130260_());
                this.mapDataList.add(mapData);
            }
        }

        @Override
        public List<PermissionEvent> getPermissionEvents() {
            return new LinkedList<PermissionEvent>(this.permissionEvents);
        }

        @Override
        public List<IColonyEventDescription> getColonyEvents() {
            return new LinkedList<IColonyEventDescription>(this.colonyEvents);
        }

        @Override
        public boolean canPlayerUseTP() {
            return this.canPlayerUseTP;
        }

        public List<MapItemSavedData> getMapDataList() {
            return this.mapDataList;
        }
    }
}

