/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.AbstractTileEntityWareHouse;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.client.gui.WindowHutMinPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.coremod.colony.buildings.modules.WarehouseModule;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PickupRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseConcreteRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.WarehouseRequestResolver;
import com.minecolonies.coremod.tileentities.TileEntityWareHouse;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class BuildingWareHouse
extends AbstractBuilding
implements IWareHouse {
    private static final String WAREHOUSE = "warehouse";
    private static final int MAX_LEVEL = 5;
    public static final int MAX_STORAGE_UPGRADE = 3;

    public BuildingWareHouse(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void requestRepair(BlockPos builder) {
        for (BlockPos pos : this.containerList) {
            BlockEntity entity;
            if (this.getColony().getWorld() == null || !((entity = this.getColony().getWorld().m_7702_(pos)) instanceof TileEntityRack)) continue;
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
        }
        super.requestRepair(builder);
    }

    @Override
    public boolean canAccessWareHouse(ICitizenData citizenData) {
        return ((CourierAssignmentModule)this.getFirstModuleOccurance(CourierAssignmentModule.class)).hasAssignedCitizen(citizenData);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return WAREHOUSE;
    }

    @Override
    public AbstractTileEntityWareHouse getTileEntity() {
        AbstractTileEntityColonyBuilding entity = super.getTileEntity();
        return !(entity instanceof TileEntityWareHouse) ? null : (AbstractTileEntityWareHouse)entity;
    }

    @Override
    public boolean hasContainerPosition(BlockPos inDimensionLocation) {
        return this.containerList.contains(inDimensionLocation) || this.getLocation().getInDimensionLocation().equals((Object)inDimensionLocation);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        BlockEntity entity;
        if (block instanceof BlockMinecoloniesRack && (entity = world.m_7702_(pos)) instanceof TileEntityRack) {
            ((AbstractTileEntityRack)entity).setInWarehouse(true);
            while (((TileEntityRack)entity).getUpgradeSize() < ((WarehouseModule)this.getFirstModuleOccurance(WarehouseModule.class)).getStorageUpgrade()) {
                ((TileEntityRack)entity).upgradeRackSize();
            }
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object[])new IRequestResolver[]{new WarehouseRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), new WarehouseConcreteRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN))});
        builder.add((Object)new DeliveryRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        builder.add((Object)new PickupRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public void upgradeContainers(Level world) {
        if (((WarehouseModule)this.getFirstModuleOccurance(WarehouseModule.class)).getStorageUpgrade() < 3) {
            for (BlockPos pos : this.getContainers()) {
                BlockEntity entity = world.m_7702_(pos);
                if (!(entity instanceof TileEntityRack) || entity instanceof TileEntityColonyBuilding) continue;
                ((AbstractTileEntityRack)entity).upgradeRackSize();
            }
            ((WarehouseModule)this.getFirstModuleOccurance(WarehouseModule.class)).incrementStorageUpgrade();
        }
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutMinPlaceholder<View>(this);
        }
    }
}

