/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.colonyEvents.raidEvents.norsemenevent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.coremod.colony.colonyEvents.raidEvents.HordeRaidEvent;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityNorsemenArcher;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityNorsemenChief;
import com.minecolonies.coremod.entity.mobs.norsemen.EntityShieldmaiden;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class NorsemenRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation NORSEMEN_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "norsemen_raid");

    public NorsemenRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return NORSEMEN_RAID_EVENT_TYPE_ID;
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.m_7006_(true);
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityRaiderMob) || !entity.m_6084_()) {
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityNorsemenChief && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityNorsemenArcher && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.m_20148_());
            return;
        }
        if (entity instanceof EntityShieldmaiden && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.m_20148_());
            return;
        }
        entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityRaiderMob)) {
            return;
        }
        if (entity instanceof EntityNorsemenChief) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityNorsemenArcher) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityShieldmaiden) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static NorsemenRaidEvent loadFromNBT(IColony colony, CompoundTag compound) {
        NorsemenRaidEvent event = new NorsemenRaidEvent(colony);
        event.deserializeNBT(compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.SHIELDMAIDEN;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.NORSEMEN_ARCHER;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.NORSEMEN_CHIEF;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.raid.norsemen.name");
    }
}

