/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.enchanter.EntityAIWorkEnchanter;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class JobEnchanter
extends AbstractJobCrafter<EntityAIWorkEnchanter, JobEnchanter> {
    private static final int MAX_WAITING_TICKS = 60;
    private BlockPos posToDrainFrom = null;
    private int waitingTicks = 0;

    public JobEnchanter(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.ENCHANTER_ID;
    }

    @Override
    public EntityAIWorkEnchanter generateAI() {
        return new EntityAIWorkEnchanter(this);
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        if (compound.m_128441_("buildingtodrain")) {
            this.posToDrainFrom = BlockPosUtil.read(compound, "buildingtodrain");
        }
        this.waitingTicks = compound.m_128451_("waitingticks");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.posToDrainFrom != null) {
            BlockPosUtil.write(compound, "buildingtodrain", this.posToDrainFrom);
        }
        compound.m_128405_("waitingticks", this.waitingTicks);
        return compound;
    }

    public void setBuildingToDrainFrom(BlockPos pos) {
        this.posToDrainFrom = pos;
    }

    public BlockPos getPosToDrainFrom() {
        return this.posToDrainFrom;
    }

    public boolean incrementWaitingTicks() {
        if (++this.waitingTicks > 60) {
            this.waitingTicks = 0;
            return false;
        }
        return true;
    }

    @Override
    public void playSound(BlockPos blockPos, EntityCitizen worker) {
        worker.queueSound(SoundEvents.f_11887_, worker.m_20183_().m_7494_(), 10, 0, 0.5f, worker.m_217043_().m_188501_());
    }
}

