/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.managers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingDataManager;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.huts.BlockHutTavern;
import com.minecolonies.coremod.blocks.huts.BlockHutTownHall;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.buildings.BuildingMysticalSite;
import com.minecolonies.coremod.colony.buildings.modules.FieldsModule;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLibrary;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.fields.registry.FieldDataManager;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewBuildingViewMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewFieldsUpdateMessage;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveBuildingMessage;
import com.minecolonies.coremod.quests.objectives.IBuildingUpgradeObjectiveTemplate;
import com.minecolonies.coremod.tileentities.TileEntityDecorationController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegisteredStructureManager
implements IRegisteredStructureManager {
    private static final Map<BuildingEntry, List<IQuestInstance>> buildBuildingObjectives = new HashMap<BuildingEntry, List<IQuestInstance>>();
    @NotNull
    private ImmutableMap<BlockPos, IBuilding> buildings = ImmutableMap.of();
    private final Set<IField> fields = ConcurrentHashMap.newKeySet();
    private final List<IWareHouse> wareHouses = new ArrayList<IWareHouse>();
    private final List<IMysticalSite> mysticalSites = new ArrayList<IMysticalSite>();
    private ImmutableList<BlockPos> leisureSites = ImmutableList.of();
    @Nullable
    private ITownHall townHall;
    private boolean isBuildingsDirty = false;
    private boolean isFieldsDirty = false;
    private final Colony colony;
    private int minChunkX;
    private int maxChunkX;
    private int minChunkZ;
    private int maxChunkZ;

    public RegisteredStructureManager(Colony colony) {
        this.colony = colony;
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        int i;
        this.buildings = ImmutableMap.of();
        this.maxChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.minChunkX = this.colony.getCenter().m_123341_() >> 4;
        this.maxChunkZ = this.colony.getCenter().m_123343_() >> 4;
        this.minChunkZ = this.colony.getCenter().m_123343_() >> 4;
        if (compound.m_128441_("fields")) {
            ListTag fieldsTagList = compound.m_128437_("fields", 10);
            for (i = 0; i < fieldsTagList.size(); ++i) {
                CompoundTag fieldCompound = fieldsTagList.m_128728_(i);
                IField field = FieldDataManager.compoundToField(fieldCompound);
                if (field == null) continue;
                this.addField(field);
            }
        }
        ListTag buildingTagList = compound.m_128437_("buildings", 10);
        for (i = 0; i < buildingTagList.size(); ++i) {
            CompoundTag buildingCompound = buildingTagList.m_128728_(i);
            @Nullable IBuilding b = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, buildingCompound);
            if (b == null) continue;
            this.addBuilding(b);
            this.setMaxChunk(b);
        }
        if (compound.m_128441_("leisureSites")) {
            ListTag leisureTagList = compound.m_128437_("leisureSites", 10);
            ArrayList<BlockPos> leisureSitesList = new ArrayList<BlockPos>();
            for (int i2 = 0; i2 < leisureTagList.size(); ++i2) {
                BlockPos pos = BlockPosUtil.read(leisureTagList.m_128728_(i2), "pos");
                if (leisureSitesList.contains(pos)) continue;
                leisureSitesList.add(pos);
            }
            this.leisureSites = ImmutableList.copyOf(leisureSitesList);
        }
        for (IField field : this.fields.stream().filter(IField::isTaken).toList()) {
            IBuilding building = (IBuilding)this.buildings.get((Object)field.getBuildingId());
            if (building == null) {
                field.resetOwningBuilding();
                continue;
            }
            FieldsModule fieldsModule = building.getFirstOptionalModuleOccurance(FieldsModule.class).orElse(null);
            if (fieldsModule != null && field.getClass().equals(fieldsModule.getExpectedFieldType())) continue;
            field.resetOwningBuilding();
            if (fieldsModule == null) continue;
            fieldsModule.freeField(field);
        }
    }

    private void setMaxChunk(IBuilding b) {
        int chunkX = b.getPosition().m_123341_() >> 4;
        int chunkZ = b.getPosition().m_123343_() >> 4;
        if (chunkX >= this.maxChunkX) {
            this.maxChunkX = chunkX + 1;
        }
        if (chunkX <= this.minChunkX) {
            this.minChunkX = chunkX - 1;
        }
        if (chunkZ >= this.maxChunkZ) {
            this.maxChunkZ = chunkZ + 1;
        }
        if (chunkZ <= this.minChunkZ) {
            this.minChunkZ = chunkZ - 1;
        }
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag buildingTagList = new ListTag();
        for (IBuilding b : this.buildings.values()) {
            @NotNull CompoundTag buildingCompound = b.serializeNBT();
            buildingTagList.add((Object)buildingCompound);
        }
        compound.m_128365_("buildings", (Tag)buildingTagList);
        compound.m_128365_("fields", (Tag)this.fields.stream().map(FieldDataManager::fieldToCompound).collect(NBTUtils.toListNBT()));
        @NotNull ListTag leisureTagList = new ListTag();
        for (BlockPos pos : this.leisureSites) {
            @NotNull CompoundTag leisureCompound = new CompoundTag();
            BlockPosUtil.write(leisureCompound, "pos", pos);
            leisureTagList.add((Object)leisureCompound);
        }
        compound.m_128365_("leisureSites", (Tag)leisureTagList);
    }

    @Override
    public void clearDirty() {
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
        this.buildings.values().forEach(ISchematicProvider::clearDirty);
    }

    @Override
    public void sendPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        this.sendBuildingPackets(closeSubscribers, newSubscribers);
        this.sendFieldPackets(closeSubscribers, newSubscribers);
        this.isBuildingsDirty = false;
        this.isFieldsDirty = false;
    }

    @Override
    public void onColonyTick(IColony colony) {
        for (IBuilding building : this.buildings.values()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), building.getPosition())) continue;
            building.onColonyTick(colony);
        }
    }

    @Override
    public void markBuildingsDirty() {
        this.isBuildingsDirty = true;
    }

    @Override
    public void cleanUpBuildings(@NotNull IColony colony) {
        @Nullable ArrayList<IBuilding> removedBuildings = new ArrayList<IBuilding>();
        ArrayList tempBuildings = new ArrayList(this.buildings.values());
        for (IBuilding building : tempBuildings) {
            BlockPos loc = building.getPosition();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), loc) || building.isMatchingBlock(colony.getWorld().m_8055_(loc).m_60734_())) continue;
            removedBuildings.add(building);
        }
        for (IField field : this.fields) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), field.getPosition()) || colony.isCoordInColony(colony.getWorld(), field.getPosition()) && field.isValidPlacement(colony)) continue;
            this.removeField(f -> f.equals(field));
        }
        for (BlockPos pos : this.leisureSites) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), pos) || colony.getWorld().m_7702_(pos) instanceof TileEntityDecorationController) continue;
            this.removeLeisureSite(pos);
        }
        if (!removedBuildings.isEmpty() && removedBuildings.size() >= this.buildings.values().size()) {
            Log.getLogger().warn("Colony:" + colony.getID() + " is removing all buildings at once. Did you just load a backup? If not there is a chance that colony data got corrupted and you want to restore a backup.");
        }
        removedBuildings.forEach(IBuilding::destroy);
    }

    @Override
    public IBuilding getBuilding(BlockPos buildingId) {
        if (buildingId != null) {
            return (IBuilding)this.buildings.get((Object)buildingId);
        }
        return null;
    }

    @Override
    public List<BlockPos> getLeisureSites() {
        return this.leisureSites;
    }

    @Override
    public BlockPos getRandomLeisureSite() {
        BlockPos pos = null;
        int randomDist = MathUtils.RANDOM.nextInt(4);
        if (randomDist < 1 && (pos = this.getFirstBuildingMatching(b -> b instanceof BuildingTownHall && b.getBuildingLevel() >= 3)) != null) {
            return pos;
        }
        if (randomDist < 2 && (MathUtils.RANDOM.nextBoolean() ? (pos = this.getFirstBuildingMatching(b -> b instanceof BuildingMysticalSite && b.getBuildingLevel() >= 1)) != null : (pos = this.getFirstBuildingMatching(b -> b instanceof BuildingLibrary && b.getBuildingLevel() >= 1)) != null)) {
            return pos;
        }
        if (randomDist < 3 && (pos = this.getFirstBuildingMatching(b -> b.hasModule(TavernBuildingModule.class) && b.getBuildingLevel() >= 1)) != null) {
            return pos;
        }
        return this.leisureSites.isEmpty() ? null : (BlockPos)this.leisureSites.get(MathUtils.RANDOM.nextInt(this.leisureSites.size()));
    }

    @Override
    @Nullable
    public BlockPos getFirstBuildingMatching(Predicate<IBuilding> predicate) {
        for (IBuilding building : this.buildings.values()) {
            if (!predicate.test(building)) continue;
            return building.getPosition();
        }
        return null;
    }

    @Override
    public void addLeisureSite(BlockPos pos) {
        ArrayList<BlockPos> tempList = new ArrayList<BlockPos>((Collection<BlockPos>)this.leisureSites);
        if (!tempList.contains(pos)) {
            tempList.add(pos);
            this.leisureSites = ImmutableList.copyOf(tempList);
            this.markBuildingsDirty();
        }
    }

    @Override
    public void removeLeisureSite(BlockPos pos) {
        if (this.leisureSites.contains((Object)pos)) {
            ArrayList<BlockPos> tempList = new ArrayList<BlockPos>((Collection<BlockPos>)this.leisureSites);
            tempList.remove(pos);
            this.leisureSites = ImmutableList.copyOf(tempList);
            this.markBuildingsDirty();
        }
    }

    @Override
    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos pos) {
        IWareHouse wareHouse = null;
        double dist = 0.0;
        for (IWareHouse building : this.wareHouses) {
            if (building.getBuildingLevel() <= 0 || building.getTileEntity() == null) continue;
            double tempDist = building.getPosition().m_123331_((Vec3i)pos);
            if (wareHouse != null && !(tempDist < dist)) continue;
            dist = tempDist;
            wareHouse = building;
        }
        return wareHouse;
    }

    @Override
    public boolean isWithinBuildingZone(LevelChunk chunk) {
        IColonyTagCapability cap = chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
        if (cap != null) {
            Set<BlockPos> capList = cap.getAllClaimingBuildings().get(this.colony.getID());
            return capList != null && capList.size() >= (Integer)MineColonies.getConfig().getServer().colonyLoadStrictness.get();
        }
        return false;
    }

    @Override
    public IBuilding getHouseWithSpareBed() {
        for (IBuilding building : this.buildings.values()) {
            LivingBuildingModule module;
            if (!building.hasModule(LivingBuildingModule.class) || HiringMode.LOCKED.equals((Object)(module = (LivingBuildingModule)building.getFirstModuleOccurance(LivingBuildingModule.class)).getHiringMode()) || module.getAssignedCitizen().size() >= module.getModuleMax()) continue;
            return building;
        }
        return null;
    }

    @Override
    @NotNull
    public Map<BlockPos, IBuilding> getBuildings() {
        return this.buildings;
    }

    @Override
    @Nullable
    public ITownHall getTownHall() {
        return this.townHall;
    }

    @Override
    public int getMysticalSiteMaxBuildingLevel() {
        int maxLevel = 0;
        if (this.hasMysticalSite()) {
            for (IMysticalSite mysticalSite : this.mysticalSites) {
                if (mysticalSite.getBuildingLevel() <= maxLevel) continue;
                maxLevel = mysticalSite.getBuildingLevel();
            }
        }
        return maxLevel;
    }

    @Override
    public boolean hasWarehouse() {
        return !this.wareHouses.isEmpty();
    }

    @Override
    public boolean hasMysticalSite() {
        return !this.mysticalSites.isEmpty();
    }

    @Override
    public boolean hasTownHall() {
        return this.townHall != null;
    }

    @Override
    public <B extends IBuilding> B getBuilding(BlockPos buildingId, @NotNull Class<B> type) {
        try {
            return (B)((IBuilding)type.cast(this.buildings.get((Object)buildingId)));
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("getBuilding called with wrong type: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding tileEntity, Level world) {
        tileEntity.setColony(this.colony);
        if (!this.buildings.containsKey((Object)tileEntity.getPosition())) {
            @Nullable IBuilding building = IBuildingDataManager.getInstance().createFrom((IColony)this.colony, tileEntity);
            if (building != null) {
                this.addBuilding(building);
                tileEntity.setBuilding(building);
                building.upgradeBuildingLevelToSchematicData();
                Log.getLogger().debug(String.format("Colony %d - new Building %s for %s at %s", this.colony.getID(), building.getBuildingDisplayName(), tileEntity.m_58900_().m_60734_(), tileEntity.getPosition()));
                building.setIsMirrored(tileEntity.isMirrored());
                if (tileEntity.getStructurePack() != null) {
                    building.setStructurePack(tileEntity.getStructurePack().getName());
                    building.setBlueprintPath(tileEntity.getBlueprintPath());
                } else {
                    building.setStructurePack(this.colony.getStructurePack());
                }
                if (world != null && !(building instanceof IRSComponent)) {
                    building.onPlacement();
                    ConstructionTapeHelper.placeConstructionTape(building, world);
                }
                this.colony.getRequestManager().onProviderAddedToColony(building);
                this.setMaxChunk(building);
            } else {
                Log.getLogger().error(String.format("Colony %d unable to create AbstractBuilding for %s at %s", this.colony.getID(), tileEntity.m_58900_().getClass(), tileEntity.getPosition()), (Throwable)new Exception());
            }
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.colony.getPackageManager().updateSubscribers();
            return building;
        }
        return null;
    }

    @Override
    public void removeBuilding(@NotNull IBuilding building, Set<ServerPlayer> subscribers) {
        if (this.buildings.containsKey((Object)building.getID())) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (IBuilding tbuilding : this.buildings.values()) {
                if (tbuilding == building) continue;
                builder.put((Object)tbuilding.getID(), (Object)tbuilding);
            }
            this.buildings = builder.build();
            for (ServerPlayer player : subscribers) {
                Network.getNetwork().sendToPlayer(new ColonyViewRemoveBuildingMessage(this.colony, building.getID()), player);
            }
            Log.getLogger().info(String.format("Colony %d - removed AbstractBuilding %s of type %s", this.colony.getID(), building.getID(), building.getSchematicName()));
        }
        if (building instanceof BuildingTownHall) {
            this.townHall = null;
        } else if (building instanceof BuildingWareHouse) {
            this.wareHouses.remove(building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.remove(building);
        }
        for (ICitizenData citizen : this.colony.getCitizenManager().getCitizens()) {
            citizen.onRemoveBuilding(building);
            building.cancelAllRequestsOfCitizen(citizen);
        }
        this.colony.getRequestManager().onProviderRemovedFromColony(building);
        this.colony.getRequestManager().onRequesterRemovedFromColony(building.getRequester());
        this.colony.getCitizenManager().calculateMaxCitizens();
    }

    @Override
    public BlockPos getBestBuilding(AbstractEntityCitizen citizen, Class<? extends IBuilding> clazz) {
        return this.getBestBuilding(citizen.m_20183_(), clazz);
    }

    @Override
    public BlockPos getBestBuilding(BlockPos citizen, Class<? extends IBuilding> clazz) {
        double distance = Double.MAX_VALUE;
        BlockPos goodCook = null;
        for (IBuilding building : this.buildings.values()) {
            double localDistance;
            if (!clazz.isInstance(building) || building.getBuildingLevel() <= 0 || !((localDistance = building.getPosition().m_123331_((Vec3i)citizen)) < distance)) continue;
            distance = localDistance;
            goodCook = building.getPosition();
        }
        return goodCook;
    }

    @Override
    public BlockPos getRandomBuilding(Predicate<IBuilding> filterPredicate) {
        ArrayList<IBuilding> allowedBuildings = new ArrayList<IBuilding>();
        for (IBuilding building : this.buildings.values()) {
            if (!filterPredicate.test(building)) continue;
            allowedBuildings.add(building);
        }
        if (allowedBuildings.isEmpty()) {
            return null;
        }
        return ((IBuilding)allowedBuildings.get(MathUtils.RANDOM.nextInt(allowedBuildings.size()))).getPosition();
    }

    @Override
    public boolean hasGuardBuildingNear(IBuilding building) {
        if (building == null) {
            return true;
        }
        for (IBuilding colonyBuilding : this.getBuildings().values()) {
            BoundingBox guardedRegion;
            if (!(colonyBuilding instanceof IGuardBuilding) && !(colonyBuilding instanceof BuildingBarracks) || !(guardedRegion = BlockPosUtil.getChunkAlignedBB(colonyBuilding.getPosition(), colonyBuilding.getClaimRadius(colonyBuilding.getBuildingLevel()))).m_71051_((Vec3i)building.getPosition())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void guardBuildingChangedAt(IBuilding guardBuilding, int newLevel) {
        int claimRadius = guardBuilding.getClaimRadius(Math.max(guardBuilding.getBuildingLevel(), newLevel));
        BoundingBox guardedRegion = BlockPosUtil.getChunkAlignedBB(guardBuilding.getPosition(), claimRadius);
        for (IBuilding building : this.getBuildings().values()) {
            if (!guardedRegion.m_71051_((Vec3i)building.getPosition())) continue;
            building.resetGuardBuildingNear();
        }
    }

    @Override
    public void setTownHall(@Nullable ITownHall building) {
        this.townHall = building;
    }

    @Override
    public List<IWareHouse> getWareHouses() {
        return this.wareHouses;
    }

    @Override
    public void removeWareHouse(IWareHouse wareHouse) {
        this.wareHouses.remove(wareHouse);
    }

    @Override
    public List<IMysticalSite> getMysticalSites() {
        return this.mysticalSites;
    }

    @Override
    public void removeMysticalSite(IMysticalSite mysticalSite) {
        this.mysticalSites.remove(mysticalSite);
    }

    @Override
    public void markFieldsDirty() {
        this.isFieldsDirty = true;
    }

    private void addBuilding(@NotNull IBuilding building) {
        this.buildings = new ImmutableMap.Builder().putAll(this.buildings).put((Object)building.getID(), (Object)building).build();
        building.markDirty();
        if (building instanceof BuildingTownHall && this.townHall == null) {
            this.townHall = (ITownHall)building;
        }
        if (building instanceof BuildingWareHouse) {
            this.wareHouses.add((IWareHouse)building);
        } else if (building instanceof BuildingMysticalSite) {
            this.mysticalSites.add((IMysticalSite)building);
        }
    }

    private void sendBuildingPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isBuildingsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isBuildingsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            for (IBuilding building : this.buildings.values()) {
                if (!building.isDirty() && newSubscribers.isEmpty()) continue;
                ColonyViewBuildingViewMessage message = new ColonyViewBuildingViewMessage(building);
                players.forEach(player -> Network.getNetwork().sendToPlayer(message, (ServerPlayer)player));
            }
        }
    }

    private void sendFieldPackets(Set<ServerPlayer> closeSubscribers, Set<ServerPlayer> newSubscribers) {
        if (this.isFieldsDirty || !newSubscribers.isEmpty()) {
            HashSet<ServerPlayer> players = new HashSet<ServerPlayer>();
            if (this.isFieldsDirty) {
                players.addAll(closeSubscribers);
            }
            players.addAll(newSubscribers);
            players.forEach(player -> Network.getNetwork().sendToPlayer(new ColonyViewFieldsUpdateMessage(this.colony, this.fields), (ServerPlayer)player));
        }
    }

    @Override
    public boolean canPlaceAt(Block block, BlockPos pos, Player player) {
        if (block instanceof BlockHutTownHall) {
            if (this.colony.hasTownHall()) {
                if (this.colony.getWorld() != null && !this.colony.getWorld().f_46443_) {
                    MessageUtils.format("tile.blockhuttownhall.messageplacedalready", new Object[0]).sendTo(player);
                }
                return false;
            }
            return true;
        }
        if (block instanceof BlockHutTavern) {
            for (IBuilding building : this.buildings.values()) {
                if (!building.hasModule(TavernBuildingModule.class)) continue;
                MessageUtils.format("tile.blockhut.tavern.limit", new Object[0]).sendTo(player);
                return false;
            }
        }
        return true;
    }

    @Override
    public void onBuildingUpgradeComplete(@Nullable IBuilding building, int level) {
        if (building != null) {
            this.colony.getCitizenManager().calculateMaxCitizens();
            this.markBuildingsDirty();
            if (buildBuildingObjectives.containsKey(building.getBuildingType())) {
                for (IQuestInstance instance : new ArrayList(buildBuildingObjectives.get(building.getBuildingType()))) {
                    IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(instance.getId()).getObjective(instance.getObjectiveIndex());
                    if (!(objective instanceof IBuildingUpgradeObjectiveTemplate)) continue;
                    IBuildingUpgradeObjectiveTemplate buildingTemplate = (IBuildingUpgradeObjectiveTemplate)((Object)objective);
                    buildingTemplate.onBuildingUpgrade(instance.getCurrentObjectiveInstance(), instance, level);
                }
            }
        }
    }

    @Override
    public void trackBuildingLevelUp(@NotNull BuildingEntry buildingEntry, @NotNull IQuestInstance colonyQuest) {
        List currentMap = buildBuildingObjectives.getOrDefault(buildingEntry, new ArrayList());
        currentMap.add(colonyQuest);
        buildBuildingObjectives.put(buildingEntry, currentMap);
    }

    @Override
    public void stopTrackingBuildingLevelUp(@NotNull BuildingEntry buildingEntry, @NotNull IQuestInstance colonyQuest) {
        ((List)buildBuildingObjectives.getOrDefault(buildingEntry, new ArrayList())).remove(colonyQuest);
    }

    @Override
    @NotNull
    public List<IField> getFields(Predicate<IField> matcher) {
        return this.fields.stream().filter(matcher).toList();
    }

    @Override
    public Optional<IField> getField(Predicate<IField> matcher) {
        return this.getFields(matcher).stream().findFirst();
    }

    @Override
    public boolean addField(IField field) {
        if (this.fields.add(field)) {
            this.markFieldsDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removeField(Predicate<IField> matcher) {
        List<IField> fieldsToRemove = this.fields.stream().filter(matcher).toList();
        for (IField field : fieldsToRemove) {
            this.fields.remove(field);
            this.markFieldsDirty();
        }
    }
}

