/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.permissions;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.OldRank;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.colony.Colony;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Permissions
implements IPermissions {
    private static final String TAG_OWNERS = "owners";
    private static final String TAG_ID = "id";
    private static final String TAG_RANK = "rank";
    private static final String TAG_PERMISSIONS = "permissionMap";
    private static final String TAG_FLAGS = "flags";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_OWNER_ID = "ownerid";
    private static final String TAG_FULLY_ABANDONED = "fully_abandoned";
    private static final String TAG_RANKS = "ranks";
    private static final String TAG_SUBSCRIBER = "is_subscriber";
    private static final String TAG_INITIAL = "is_initial";
    private static final String TAG_COLONY_MANAGER = "is_colony_manager";
    private static final String TAG_HOSTILE = "is_hostile";
    private static final String TAG_VERSION = "permissionVersion";
    private final Map<Integer, Rank> ranks = new LinkedHashMap<Integer, Rank>();
    private static int fullyAbandonedPermissionsFlag = 0;
    @NotNull
    private final Colony colony;
    @NotNull
    private final Map<UUID, ColonyPlayer> players = new HashMap<UUID, ColonyPlayer>();
    private boolean dirty = false;
    private String ownerName = "";
    private UUID ownerUUID = null;
    private boolean fullyAbandoned = false;
    private static final int permissionsVersion = 4;

    public Permissions(@NotNull Colony colony) {
        this.clearDirty();
        this.colony = colony;
        this.loadRanks();
    }

    private void loadRanks() {
        this.ranks.clear();
        block7: for (OldRank oldRank : OldRank.values()) {
            Object name = oldRank.name();
            name = ((String)name).substring(0, 1).toUpperCase(Locale.ENGLISH) + ((String)name).substring(1).toLowerCase(Locale.ENGLISH);
            Rank rank = new Rank(oldRank.ordinal(), (String)name, oldRank.isSubscriber, true);
            this.ranks.put(rank.getId(), rank);
            switch (oldRank) {
                case OWNER: {
                    rank.addPermission(Action.EDIT_PERMISSIONS);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.addPermission(Action.MAP_DEATHS);
                }
                case OFFICER: {
                    rank.addPermission(Action.PLACE_HUTS);
                    rank.addPermission(Action.BREAK_HUTS);
                    rank.addPermission(Action.MANAGE_HUTS);
                    rank.addPermission(Action.RECEIVE_MESSAGES);
                    rank.addPermission(Action.PLACE_BLOCKS);
                    rank.addPermission(Action.BREAK_BLOCKS);
                    rank.addPermission(Action.FILL_BUCKET);
                    rank.addPermission(Action.OPEN_CONTAINER);
                    rank.addPermission(Action.RECEIVE_MESSAGES_FAR_AWAY);
                    rank.addPermission(Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY);
                    rank.addPermission(Action.RALLY_GUARDS);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.addPermission(Action.MAP_DEATHS);
                    rank.setColonyManager(true);
                }
                case FRIEND: {
                    rank.addPermission(Action.ACCESS_HUTS);
                    rank.addPermission(Action.USE_SCAN_TOOL);
                    rank.addPermission(Action.TOSS_ITEM);
                    rank.addPermission(Action.PICKUP_ITEM);
                    rank.addPermission(Action.RIGHTCLICK_BLOCK);
                    rank.addPermission(Action.RIGHTCLICK_ENTITY);
                    rank.addPermission(Action.THROW_POTION);
                    rank.addPermission(Action.SHOOT_ARROW);
                    rank.addPermission(Action.ATTACK_CITIZEN);
                    rank.addPermission(Action.ATTACK_ENTITY);
                    rank.addPermission(Action.TELEPORT_TO_COLONY);
                    rank.addPermission(Action.MAP_BORDER);
                }
                case NEUTRAL: {
                    rank.addPermission(Action.ACCESS_FREE_BLOCKS);
                    rank.addPermission(Action.MAP_BORDER);
                    continue block7;
                }
                case HOSTILE: {
                    rank.addPermission(Action.GUARDS_ATTACK);
                    rank.addPermission(Action.HURT_CITIZEN);
                    rank.addPermission(Action.HURT_VISITOR);
                    rank.addPermission(Action.MAP_BORDER);
                    rank.setHostile(true);
                    continue block7;
                }
            }
        }
    }

    private void upgradePermissions(int version, Rank rank) {
        if (version < 4) {
            if (rank.isHostile()) {
                this.setPermission(rank, Action.HURT_CITIZEN, true);
                this.setPermission(rank, Action.HURT_VISITOR, true);
            }
            if (rank.isColonyManager()) {
                this.setPermission(rank, Action.MAP_DEATHS, true);
            }
            this.setPermission(rank, Action.MAP_BORDER, true);
        }
        if (rank == this.getRankOwner()) {
            rank.addPermission(Action.EDIT_PERMISSIONS);
            rank.addPermission(Action.ACCESS_HUTS);
            rank.addPermission(Action.MANAGE_HUTS);
        }
    }

    @Override
    public final boolean setPermission(Rank rank, @NotNull Action action, boolean enable) {
        boolean changed = enable ? rank.addPermission(action) : rank.removePermission(action);
        if (changed) {
            this.markDirty();
        }
        return changed;
    }

    private void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.markDirty();
        }
    }

    @Override
    public boolean alterPermission(Rank actor, Rank rank, @NotNull Action action, boolean enable) {
        if (!this.canAlterPermission(actor, rank, action)) {
            return false;
        }
        return this.setPermission(rank, action, enable);
    }

    @Override
    public boolean canAlterPermission(Rank actor, Rank rank, @NotNull Action action) {
        if (rank == this.getRankOwner() && actor != this.getRankOwner()) {
            return false;
        }
        return this.hasPermission(actor, Action.EDIT_PERMISSIONS) && (actor != rank || action != Action.EDIT_PERMISSIONS && action != Action.MANAGE_HUTS && action != Action.ACCESS_HUTS);
    }

    public void loadPermissions(@NotNull CompoundTag compound) {
        String name;
        int version = compound.m_128451_(TAG_VERSION);
        if (compound.m_128441_(TAG_RANKS)) {
            this.ranks.clear();
            ListTag rankTagList = compound.m_128437_(TAG_RANKS, 10);
            for (int i = 0; i < rankTagList.size(); ++i) {
                CompoundTag rankCompound = rankTagList.m_128728_(i);
                int id = rankCompound.m_128451_(TAG_ID);
                name = rankCompound.m_128461_("name");
                boolean isSubscriber = rankCompound.m_128471_(TAG_SUBSCRIBER);
                boolean isInitial = rankCompound.m_128471_(TAG_INITIAL);
                boolean isColonyManager = rankCompound.m_128471_(TAG_COLONY_MANAGER);
                boolean isHostile = rankCompound.m_128471_(TAG_HOSTILE);
                Rank rank = new Rank(id, 0L, name, isSubscriber, isInitial, isColonyManager, isHostile);
                this.ranks.put(id, rank);
                this.upgradePermissions(version, rank);
            }
            ListTag permissionsTagList = compound.m_128437_(TAG_PERMISSIONS, 10);
            for (int i = 0; i < permissionsTagList.size(); ++i) {
                CompoundTag permissionsCompound = permissionsTagList.m_128728_(i);
                Rank rank = this.ranks.get(permissionsCompound.m_128451_(TAG_RANK));
                if (rank == null) continue;
                ListTag flagsTagList = permissionsCompound.m_128437_(TAG_FLAGS, 8);
                for (int j = 0; j < flagsTagList.size(); ++j) {
                    String flag = flagsTagList.m_128778_(j);
                    try {
                        rank.addPermission(Action.valueOf(flag));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        } else {
            this.loadRanks();
        }
        this.players.clear();
        ListTag ownerTagList = compound.m_128437_(TAG_OWNERS, 10);
        for (int i = 0; i < ownerTagList.size(); ++i) {
            Rank rank;
            CompoundTag ownerCompound = ownerTagList.m_128728_(i);
            @NotNull UUID id = UUID.fromString(ownerCompound.m_128461_(TAG_ID));
            name = "";
            if (ownerCompound.m_128441_("name")) {
                name = ownerCompound.m_128461_("name");
            }
            if (version >= 3) {
                rank = this.ranks.get(ownerCompound.m_128451_(TAG_RANK));
            } else {
                OldRank oldRank = OldRank.valueOf(ownerCompound.m_128461_(TAG_RANK));
                rank = this.ranks.get(oldRank.ordinal());
            }
            GameProfile player = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(id).orElse(null);
            if (player != null && rank != null) {
                this.players.put(id, new ColonyPlayer(id, player.getName(), rank));
                continue;
            }
            if (name.isEmpty() || rank == null) continue;
            this.players.put(id, new ColonyPlayer(id, name, rank));
        }
        if (compound.m_128441_(TAG_OWNER)) {
            this.ownerName = compound.m_128461_(TAG_OWNER);
        }
        if (compound.m_128441_(TAG_OWNER_ID)) {
            try {
                this.ownerUUID = UUID.fromString(compound.m_128461_(TAG_OWNER_ID));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (compound.m_128441_(TAG_FULLY_ABANDONED)) {
            this.fullyAbandoned = compound.m_128471_(TAG_FULLY_ABANDONED);
        } else {
            this.checkFullyAbandoned();
        }
        this.restoreOwnerIfNull();
    }

    @Override
    public void restoreOwnerIfNull() {
        Map.Entry<UUID, ColonyPlayer> owner = this.getOwnerEntry();
        if (owner == null && this.ownerUUID != null) {
            GameProfile player = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(this.ownerUUID).orElse(null);
            if (player != null) {
                this.players.put(this.ownerUUID, new ColonyPlayer(this.ownerUUID, player.getName(), this.ranks.get(0)));
            }
        } else if (owner == null) {
            this.setOwnerAbandoned();
        }
    }

    @Override
    @Nullable
    public Map.Entry<UUID, ColonyPlayer> getOwnerEntry() {
        for (Map.Entry<UUID, ColonyPlayer> entry : this.players.entrySet()) {
            if (entry.getValue().getRank().getId() != 0) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean setOwner(Player player) {
        this.players.remove(this.getOwner());
        this.ownerName = player.m_7755_().getString();
        this.ownerUUID = player.m_20148_();
        this.players.put(this.ownerUUID, new ColonyPlayer(this.ownerUUID, player.m_7755_().getString(), this.ranks.get(0)));
        this.fullyAbandoned = false;
        this.markDirty();
        return true;
    }

    @Override
    public void setOwnerAbandoned() {
        this.players.remove(this.ownerUUID);
        this.ownerName = "[abandoned]";
        this.ownerUUID = UUID.randomUUID();
        this.players.put(this.ownerUUID, new ColonyPlayer(this.ownerUUID, this.ownerName, this.ranks.get(0)));
        this.checkFullyAbandoned();
        this.markDirty();
    }

    @Override
    @NotNull
    public UUID getOwner() {
        if (this.ownerUUID == null) {
            Map.Entry<UUID, ColonyPlayer> owner = this.getOwnerEntry();
            if (owner != null) {
                this.ownerUUID = owner.getKey();
            } else {
                this.restoreOwnerIfNull();
            }
        }
        return this.ownerUUID;
    }

    public void savePermissions(@NotNull CompoundTag compound) {
        @NotNull ListTag rankTagList = new ListTag();
        for (Rank rank : this.ranks.values()) {
            @NotNull CompoundTag rankCompound = new CompoundTag();
            rankCompound.m_128405_(TAG_ID, rank.getId());
            rankCompound.m_128359_("name", rank.getName());
            rankCompound.m_128379_(TAG_SUBSCRIBER, rank.isSubscriber());
            rankCompound.m_128379_(TAG_INITIAL, rank.isInitial());
            rankCompound.m_128379_(TAG_COLONY_MANAGER, rank.isColonyManager());
            rankCompound.m_128379_(TAG_HOSTILE, rank.isHostile());
            rankTagList.add((Object)rankCompound);
        }
        compound.m_128365_(TAG_RANKS, (Tag)rankTagList);
        @NotNull ListTag ownerTagList = new ListTag();
        for (ColonyPlayer player : this.players.values()) {
            @NotNull CompoundTag ownersCompound = new CompoundTag();
            ownersCompound.m_128359_(TAG_ID, player.getID().toString());
            ownersCompound.m_128359_("name", player.getName());
            ownersCompound.m_128405_(TAG_RANK, player.getRank().getId());
            ownerTagList.add((Object)ownersCompound);
        }
        compound.m_128365_(TAG_OWNERS, (Tag)ownerTagList);
        @NotNull ListTag listTag = new ListTag();
        for (Rank rank : this.ranks.values()) {
            @NotNull CompoundTag permissionsCompound = new CompoundTag();
            permissionsCompound.m_128405_(TAG_RANK, rank.getId());
            @NotNull ListTag flagsTagList = new ListTag();
            for (Action action : Action.values()) {
                if (!Utils.testFlag(rank.getPermissions(), action.getFlag())) continue;
                flagsTagList.add((Object)StringTag.m_129297_((String)action.name()));
            }
            permissionsCompound.m_128365_(TAG_FLAGS, (Tag)flagsTagList);
            listTag.add((Object)permissionsCompound);
        }
        compound.m_128365_(TAG_PERMISSIONS, (Tag)listTag);
        if (!this.ownerName.isEmpty()) {
            compound.m_128359_(TAG_OWNER, this.ownerName);
        }
        if (this.ownerUUID != null) {
            compound.m_128359_(TAG_OWNER_ID, this.ownerUUID.toString());
        }
        compound.m_128379_(TAG_FULLY_ABANDONED, this.fullyAbandoned);
        compound.m_128405_(TAG_VERSION, 4);
    }

    @Override
    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    @Override
    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return Utils.testFlag(rank.getPermissions(), action.getFlag()) || this.fullyAbandoned && Utils.testFlag(fullyAbandonedPermissionsFlag, action.getFlag());
    }

    @Override
    public Set<ColonyPlayer> getPlayersByRank(Rank rank) {
        return this.players.values().stream().filter(player -> player.getRank() != null && player.getRank().equals(rank)).collect(Collectors.toSet());
    }

    @Override
    public Set<ColonyPlayer> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return this.players.values().stream().filter(player -> ranks.contains(player.getRank())).collect(Collectors.toSet());
    }

    @Override
    public Set<ColonyPlayer> getFilteredPlayers(@NotNull Predicate<Rank> predicate) {
        return this.players.values().stream().filter(player -> predicate.test(player.getRank())).collect(Collectors.toSet());
    }

    @Override
    public boolean hasPermission(@NotNull Player player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    public Rank getRank(@NotNull Player player) {
        return this.getRank(player.m_36316_().getId());
    }

    @Override
    public boolean setPlayerRank(UUID id, Rank rank, Level world) {
        ColonyPlayer player = this.getPlayers().get(id);
        if (player != null) {
            player.setRank(rank);
            if (rank.isColonyManager()) {
                this.fullyAbandoned = false;
            } else {
                this.checkFullyAbandoned();
            }
        } else {
            GameProfile gameprofile = world.m_7654_().m_129927_().m_11002_(id).orElse(null);
            return gameprofile != null && this.addPlayer(gameprofile, rank);
        }
        this.markDirty();
        return true;
    }

    @Override
    public boolean addPlayer(@NotNull UUID id, String name, Rank rank) {
        @NotNull ColonyPlayer p = new ColonyPlayer(id, name, rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        if (rank.getId() == 0 || rank.getId() == 1) {
            this.fullyAbandoned = false;
        }
        this.markDirty();
        return true;
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        ColonyPlayer player = this.players.get(id);
        return player != null ? player.getRank() : this.ranks.get(3);
    }

    @Override
    public boolean addPlayer(@NotNull String player, Rank rank, Level world) {
        ServerPlayer playerEntity;
        if (player.isEmpty()) {
            return false;
        }
        GameProfile gameprofile = world.m_7654_().m_129927_().m_10996_(player).orElse(null);
        if (!world.m_5776_() && gameprofile != null && (playerEntity = (ServerPlayer)world.m_46003_(gameprofile.getId())) != null) {
            if (rank.getId() == 1) {
                this.colony.getPackageManager().addImportantColonyPlayer(playerEntity);
                this.colony.getPackageManager().updateSubscribers();
                this.fullyAbandoned = false;
            } else if (rank.getId() == 0) {
                this.fullyAbandoned = false;
            } else {
                LevelChunk chunk = world.m_6325_(playerEntity.m_146902_().f_45578_, playerEntity.m_146902_().f_45579_);
                IColonyTagCapability colonyCap = (IColonyTagCapability)chunk.getCapability(IColony.CLOSE_COLONY_CAP, null).orElseGet(null);
                if (colonyCap != null && colonyCap.getOwningColony() == this.colony.getID() && world.m_46472_() == this.colony.getDimension()) {
                    this.colony.getPackageManager().addCloseSubscriber(playerEntity);
                    this.colony.getPackageManager().updateSubscribers();
                }
            }
        }
        return gameprofile != null && !this.ownerUUID.equals(gameprofile.getId()) && this.addPlayer(gameprofile, rank);
    }

    @Override
    public boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        @NotNull ColonyPlayer p = new ColonyPlayer(gameprofile.getId(), gameprofile.getName(), rank);
        this.players.remove(p.getID());
        this.players.put(p.getID(), p);
        if (rank.getId() == 0 || rank.getId() == 1) {
            this.fullyAbandoned = false;
        }
        this.markDirty();
        return true;
    }

    @Override
    public boolean removePlayer(UUID id) {
        ColonyPlayer player = this.players.get(id);
        if (player != null && player.getRank().getId() != 0 && this.players.remove(id) != null) {
            this.checkFullyAbandoned();
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        Map.Entry<UUID, ColonyPlayer> owner;
        if (this.ownerName.isEmpty() && (owner = this.getOwnerEntry()) != null) {
            this.ownerName = owner.getValue().getName();
        }
        return this.ownerName;
    }

    @Override
    public boolean isSubscriber(@NotNull Player player) {
        return this.isSubscriber(player.m_36316_().getId());
    }

    private boolean isSubscriber(UUID player) {
        return this.getRank(player).isSubscriber();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf, @NotNull Rank viewerRank) {
        buf.m_130130_(this.ranks.size());
        for (Rank rank : this.ranks.values()) {
            buf.m_130130_(rank.getId());
            buf.writeLong(rank.getPermissions());
            buf.m_130070_(rank.getName());
            buf.writeBoolean(rank.isSubscriber());
            buf.writeBoolean(rank.isInitial());
            buf.writeBoolean(rank.isColonyManager());
            buf.writeBoolean(rank.isHostile());
        }
        buf.m_130130_(viewerRank.getId());
        buf.m_130130_(this.players.size());
        for (Map.Entry entry : this.players.entrySet()) {
            PacketUtils.writeUUID(buf, (UUID)entry.getKey());
            buf.m_130070_(((ColonyPlayer)entry.getValue()).getName());
            buf.m_130130_(((ColonyPlayer)entry.getValue()).getRank().getId());
        }
    }

    @Override
    public boolean isColonyMember(@NotNull Player player) {
        return this.players.containsKey(player.m_36316_().getId());
    }

    private void checkFullyAbandoned() {
        if (this.getOwnerName().equals("[abandoned]") && this.getPlayersByRank(this.ranks.get(1)).isEmpty()) {
            this.fullyAbandoned = true;
        }
    }

    @Override
    public Rank getRankOwner() {
        return this.ranks.get(0);
    }

    @Override
    public Rank getRankOfficer() {
        return this.ranks.get(1);
    }

    @Override
    public Rank getRankHostile() {
        return this.ranks.get(4);
    }

    @Override
    public Rank getRankFriend() {
        return this.ranks.get(2);
    }

    @Override
    public Rank getRankNeutral() {
        return this.ranks.get(3);
    }

    @Override
    public Rank getRank(int id) {
        return this.ranks.get(id);
    }

    @Override
    public Map<Integer, Rank> getRanks() {
        return this.ranks;
    }

    @Override
    public void addRank(String name) {
        int id = 5;
        for (int i = 4; i <= this.ranks.size() + 1; ++i) {
            if (this.ranks.get(i) != null) continue;
            id = i;
            break;
        }
        Rank rank = new Rank(id, name, false, false);
        this.ranks.put(id, rank);
        this.markDirty();
    }

    @Override
    public void removeRank(Rank rank) {
        if (rank.isInitial()) {
            return;
        }
        for (ColonyPlayer player : this.getPlayersByRank(rank)) {
            player.setRank(this.getRankNeutral());
        }
        this.ranks.remove(rank.getId());
        this.markDirty();
    }

    static {
        for (Action a : Action.values()) {
            if (a == Action.GUARDS_ATTACK || a == Action.EDIT_PERMISSIONS || a == Action.MANAGE_HUTS || a == Action.TELEPORT_TO_COLONY || a == Action.EXPLODE || a == Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY || a == Action.RALLY_GUARDS) continue;
            fullyAbandonedPermissionsFlag = (int)((long)fullyAbandonedPermissionsFlag | a.getFlag());
        }
    }
}

