/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.colony.requestsystem.resolvers.core.AbstractBuildingDependentRequestResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingRequestResolver
extends AbstractBuildingDependentRequestResolver<IDeliverable> {
    public BuildingRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public int getPriority() {
        return 200;
    }

    @Override
    public TypeToken<? extends IDeliverable> getRequestType() {
        return TypeConstants.DELIVERABLE;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request) {
    }

    @Override
    public boolean canResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        if (building instanceof BuildingWareHouse) {
            return false;
        }
        if (!request.getRequest().canBeResolvedByBuilding()) {
            return false;
        }
        Predicate<ItemStack> pred = itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack).booleanValue() || !((IDeliverable)request.getRequest()).matches((ItemStack)itemStack)) {
                return false;
            }
            if (!request.hasParent()) {
                return true;
            }
            IRequest<?> requestParent = manager.getRequestForToken((IToken<?>)request.getParent());
            return requestParent.getRequestOfType(IDeliverable.class).map(d -> d.matches((ItemStack)itemStack)).orElse(false) == false;
        };
        return InventoryUtils.hasBuildingEnoughElseCount((IBuilding)building, pred, request.getRequest().getMinimumCount()) >= request.getRequest().getMinimumCount();
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        int totalRequested = request.getRequest().getCount();
        int totalAvailable = InventoryUtils.getCountFromBuilding((IBuilding)building, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
        for (Map.Entry<ItemStorage, Integer> reserved : building.reservedStacksExcluding(request).entrySet()) {
            if (!request.getRequest().matches(reserved.getKey().getItemStack())) continue;
            totalAvailable = Math.max(0, totalAvailable - reserved.getValue());
            break;
        }
        if (totalAvailable <= 0) {
            return null;
        }
        if (totalAvailable >= totalRequested) {
            return Lists.newArrayList();
        }
        if (totalAvailable >= request.getRequest().getMinimumCount()) {
            return Lists.newArrayList();
        }
        int totalRemainingRequired = totalRequested - totalAvailable;
        IDeliverable remainingRequest = request.getRequest().copyWithCount(totalRemainingRequired);
        return Lists.newArrayList((Object[])new IToken[]{manager.createRequest(this, remainingRequest)});
    }

    @Override
    public void resolveForBuilding(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> request, @NotNull AbstractBuilding building) {
        Set<ICapabilityProvider> tileEntities = this.getCapabilityProviders(manager, building);
        int total = request.getRequest().getCount();
        int current = 0;
        ArrayList<ItemStack> deliveries = new ArrayList<ItemStack>();
        for (ICapabilityProvider tile : tileEntities) {
            List<ItemStack> inv = InventoryUtils.filterProvider(tile, itemStack -> ((IDeliverable)request.getRequest()).matches((ItemStack)itemStack));
            for (ItemStack stack : inv) {
                if (stack.m_41619_() || current >= total) continue;
                deliveries.add(stack);
                current += stack.m_41613_();
            }
        }
        request.addDelivery(deliveries);
        manager.updateRequestState((IToken<?>)request.getId(), RequestState.RESOLVED);
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends IDeliverable> completedRequest) {
        return null;
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public Optional<IRequester> getBuilding(@NotNull IRequestManager manager, @NotNull IToken<?> token) {
        if (!manager.getColony().getWorld().f_46443_) {
            return Optional.ofNullable(manager.getColony().getRequesterBuildingForPosition(this.getLocation().getInDimensionLocation()));
        }
        return Optional.empty();
    }

    @NotNull
    private Set<ICapabilityProvider> getCapabilityProviders(@NotNull IRequestManager manager, @NotNull AbstractBuilding building) {
        HashSet tileEntities = Sets.newHashSet();
        tileEntities.add(building.getTileEntity());
        tileEntities.removeIf(Objects::isNull);
        return tileEntities;
    }
}

