/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.crafting.RecipeAnalyzer;
import com.minecolonies.coremod.compatibility.jei.CompostRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.FishermanRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.GenericRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.ModRecipeTypes;
import com.minecolonies.coremod.compatibility.jei.ToolRecipeCategory;
import com.minecolonies.coremod.compatibility.jei.transfer.BrewingCraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.CraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.FurnaceCraftingGuiHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateBrewingTeachingTransferHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateCraftingTeachingTransferHandler;
import com.minecolonies.coremod.compatibility.jei.transfer.PrivateSmeltingTeachingTransferHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private final List<JobBasedRecipeCategory<?>> categories = new ArrayList();

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("minecolonies");
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IModIdHelper modIdHelper = jeiHelpers.getModIdHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new ToolRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new FishermanRecipeCategory(guiHelper)});
        this.categories.clear();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            HashMap<JobEntry, GenericRecipeCategory> craftingCategories = new HashMap<JobEntry, GenericRecipeCategory>();
            for (Supplier<IBuildingModule> producer : building.getModuleProducers()) {
                GenericRecipeCategory category;
                IJob<?> job;
                IBuildingModule module = producer.get();
                if (module instanceof ICraftingBuildingModule) {
                    ICraftingBuildingModule crafting = (ICraftingBuildingModule)module;
                    job = crafting.getCraftingJob();
                    if (job == null) continue;
                    category = (GenericRecipeCategory)craftingCategories.get(job.getJobRegistryEntry());
                    if (category == null) {
                        category = new GenericRecipeCategory(building, job, guiHelper, modIdHelper);
                        craftingCategories.put(job.getJobRegistryEntry(), category);
                    }
                    category.addModule(crafting);
                    continue;
                }
                if (!(module instanceof AnimalHerdingModule)) continue;
                AnimalHerdingModule herding = (AnimalHerdingModule)module;
                job = herding.getHerdingJob();
                category = (GenericRecipeCategory)craftingCategories.get(job.getJobRegistryEntry());
                if (category == null) {
                    category = new GenericRecipeCategory(building, job, guiHelper, modIdHelper);
                    craftingCategories.put(job.getJobRegistryEntry(), category);
                }
                category.addModule(herding);
            }
            for (GenericRecipeCategory category : craftingCategories.values()) {
                this.registerCategory(registration, category);
            }
        }
    }

    private void registerCategory(@NotNull IRecipeCategoryRegistration registration, @NotNull JobBasedRecipeCategory<?> category) {
        this.categories.add(category);
        registration.addRecipeCategories(new IRecipeCategory[]{category});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ModBlocks.blockHutComposter.m_5456_()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)("com.minecolonies.coremod.jei." + ModJobs.COMPOSTER_ID.m_135815_()))});
        registration.addRecipes(ModRecipeTypes.TOOLS, ToolRecipeCategory.findRecipes());
        registration.addRecipes(ModRecipeTypes.COMPOSTING, CompostRecipeCategory.findRecipes());
        registration.addRecipes(ModRecipeTypes.FISHING, FishermanRecipeCategory.findRecipes());
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        Map<CraftingType, List<IGenericRecipe>> vanilla = RecipeAnalyzer.buildVanillaRecipesMap(level.m_7465_(), (Level)level);
        List<Animal> animals = RecipeAnalyzer.createAnimals((Level)level);
        for (JobBasedRecipeCategory<?> category : this.categories) {
            this.addJobBasedRecipes(vanilla, animals, category, (arg_0, arg_1) -> ((IRecipeRegistration)registration).addRecipes(arg_0, arg_1), (Level)level);
        }
    }

    private <R> void addJobBasedRecipes(@NotNull Map<CraftingType, List<IGenericRecipe>> vanilla, @NotNull List<Animal> animals, @NotNull JobBasedRecipeCategory<R> category, @NotNull BiConsumer<RecipeType<R>, List<R>> registrar, @NotNull Level world) {
        try {
            registrar.accept(category.getRecipeType(), category.findRecipes(vanilla, animals, world));
        }
        catch (Exception e) {
            Log.getLogger().error("Failed to process recipes for " + category.getTitle(), (Throwable)e);
        }
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockBarrel), new RecipeType[]{ModRecipeTypes.COMPOSTING});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutComposter), new RecipeType[]{ModRecipeTypes.COMPOSTING});
        registration.addRecipeCatalyst(new ItemStack(ModBlocks.blockHutFisherman), new RecipeType[]{ModRecipeTypes.FISHING});
        for (JobBasedRecipeCategory<?> category : this.categories) {
            registration.addRecipeCatalyst(category.getCatalyst(), new RecipeType[]{category.getRecipeType()});
        }
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateCraftingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateSmeltingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.SMELTING);
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new PrivateBrewingTeachingTransferHandler(registration.getTransferHelper()), RecipeTypes.BREWING);
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        new CraftingGuiHandler(this.categories).register(registration);
        new FurnaceCraftingGuiHandler(this.categories).register(registration);
        new BrewingCraftingGuiHandler(this.categories).register(registration);
    }
}

