/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.coremod.colony.buildings.moduleviews.CraftingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.compatibility.jei.JobBasedRecipeCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTeachingGuiHandler<W extends AbstractContainerScreen<?>>
implements IGuiContainerHandler<W>,
IGhostIngredientHandler<W> {
    @NotNull
    private final Map<ResourceLocation, JobBasedRecipeCategory<?>> categories;

    protected AbstractTeachingGuiHandler(@NotNull List<JobBasedRecipeCategory<?>> categories) {
        this.categories = categories.stream().collect(Collectors.toMap(category -> category.getRecipeType().getUid(), Function.identity()));
    }

    public void register(@NotNull IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(this.getWindowClass(), (IGuiContainerHandler)this);
        registration.addGhostIngredientHandler(this.getWindowClass(), (IGhostIngredientHandler)this);
    }

    @NotNull
    protected abstract Class<W> getWindowClass();

    protected abstract boolean isSupportedCraftingModule(@NotNull CraftingModuleView var1);

    protected abstract boolean isSupportedSlot(@NotNull Slot var1);

    protected abstract void updateServer(@NotNull W var1);

    @Nullable
    protected JobBasedRecipeCategory<?> getRecipeCategory(@NotNull AbstractBuildingView view) {
        for (CraftingModuleView moduleView : view.getModuleViews(CraftingModuleView.class)) {
            ResourceLocation uid;
            JobBasedRecipeCategory<?> category;
            JobEntry jobEntry;
            if (!this.isSupportedCraftingModule(moduleView) || (jobEntry = moduleView.getJobEntry()) == null || (category = this.categories.get(uid = ICraftingBuildingModule.getUid(jobEntry, moduleView.getId()))) == null) continue;
            return category;
        }
        return null;
    }

    @NotNull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(@NotNull W gui, @NotNull ITypedIngredient<I> ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType().getIngredientClass() == ItemStack.class) {
            for (final Slot slot : gui.m_6262_().f_38839_) {
                if (!slot.m_6659_() || !this.isSupportedSlot(slot)) continue;
                final Rect2i bounds = new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 17, 17);
                targets.add(new IGhostIngredientHandler.Target<I>(){
                    final /* synthetic */ AbstractContainerScreen val$gui;
                    {
                        this.val$gui = abstractContainerScreen;
                    }

                    @NotNull
                    public Rect2i getArea() {
                        return bounds;
                    }

                    public void accept(@NotNull I ingredient) {
                        slot.m_5852_((ItemStack)ingredient);
                        AbstractTeachingGuiHandler.this.updateServer(this.val$gui);
                    }
                });
            }
        }
        return targets;
    }

    public void onComplete() {
    }
}

