/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.event.ClientChunkUpdatedEvent;
import com.minecolonies.api.colony.event.ColonyViewUpdatedEvent;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.IJobRegistry;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.compatibility.journeymap.ColonyBorderMapping;
import com.minecolonies.coremod.compatibility.journeymap.ColonyDeathpoints;
import com.minecolonies.coremod.compatibility.journeymap.Journeymap;
import com.minecolonies.coremod.compatibility.journeymap.JourneymapOptions;
import com.minecolonies.coremod.entity.citizen.VisitorCitizen;
import java.util.Arrays;
import java.util.Set;
import journeymap.client.api.display.Context;
import journeymap.client.api.event.forge.EntityRadarUpdateEvent;
import journeymap.client.api.model.WrappedEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class EventListener {
    private static final Style JOB_TOOLTIP = Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131155_(Boolean.valueOf(true));
    @NotNull
    private final Journeymap jmap;

    public EventListener(@NotNull Journeymap jmap) {
        this.jmap = jmap;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerLogout(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        ColonyDeathpoints.clear();
        this.jmap.getApi().removeAll("minecolonies");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onChunkLoaded(@NotNull ChunkEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            return;
        }
        if (event.getLevel() instanceof Level) {
            ResourceKey dimension = ((Level)event.getLevel()).m_46472_();
            ColonyDeathpoints.updateChunk(this.jmap, (ResourceKey<Level>)dimension, event.getChunk());
        }
    }

    @SubscribeEvent
    public void onColonyChunkDataUpdated(@NotNull ClientChunkUpdatedEvent event) {
        ResourceKey dimension = event.getChunk().m_62953_().m_46472_();
        ColonyBorderMapping.updateChunk(this.jmap, (ResourceKey<Level>)dimension, event.getChunk());
    }

    @SubscribeEvent
    public void onColonyViewUpdated(@NotNull ColonyViewUpdatedEvent event) {
        IColonyView colony = event.getColony();
        Set<BlockPos> graves = colony.getGraveManager().getGraves().keySet();
        ColonyDeathpoints.updateGraves(this.jmap, colony, graves);
    }

    @SubscribeEvent
    public void onUpdateEntityRadar(@NotNull EntityRadarUpdateEvent event) {
        WrappedEntity wrapper = event.getWrappedEntity();
        LivingEntity entity = (LivingEntity)wrapper.getEntityLivingRef().get();
        if (entity instanceof AbstractEntityCitizen) {
            boolean showName;
            Component name;
            MutableComponent jobName;
            boolean isVisitor = entity instanceof VisitorCitizen;
            if (isVisitor) {
                if (!JourneymapOptions.getShowVisitors(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = Component.m_237115_((String)"com.minecolonies.coremod.journeymap.visitor");
            } else {
                IJob<?> job;
                String jobId = (String)entity.m_20088_().m_135370_(AbstractEntityCitizen.DATA_JOB);
                JobEntry jobEntry = (JobEntry)IJobRegistry.getInstance().getValue(new ResourceLocation(jobId));
                IJob<?> iJob = job = jobEntry == null ? null : jobEntry.produceJob(null);
                if (job instanceof AbstractJobGuard ? !JourneymapOptions.getShowGuards(this.jmap.getOptions()) : !JourneymapOptions.getShowCitizens(this.jmap.getOptions())) {
                    wrapper.setDisable(true);
                    return;
                }
                jobName = Component.m_237115_((String)(jobEntry == null ? "com.minecolonies.coremod.journeymap.unemployed" : jobEntry.getTranslationKey()));
            }
            if (JourneymapOptions.getShowColonistTooltip(this.jmap.getOptions()) && (name = entity.m_7770_()) != null) {
                wrapper.setEntityToolTips(Arrays.asList(name, jobName.m_6270_(JOB_TOOLTIP)));
            }
            boolean bl = showName = event.getActiveUiState().ui.equals((Object)Context.UI.Minimap) ? JourneymapOptions.getShowColonistNameMinimap(this.jmap.getOptions()) : JourneymapOptions.getShowColonistNameFullscreen(this.jmap.getOptions());
            if (!showName) {
                wrapper.setCustomName("");
            }
            if (!isVisitor && JourneymapOptions.getShowColonistTeamColour(this.jmap.getOptions())) {
                wrapper.setColor(entity.m_19876_());
            }
        } else if (entity instanceof AbstractEntityRaiderMob) {
            JourneymapOptions.RaiderColor color = JourneymapOptions.getRaiderColor(this.jmap.getOptions());
            if (JourneymapOptions.RaiderColor.NONE.equals((Object)color)) {
                wrapper.setDisable(true);
            } else if (!JourneymapOptions.RaiderColor.HOSTILE.equals((Object)color)) {
                wrapper.setColor(color.getColor().m_131265_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientTick(@NotNull TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            ColonyBorderMapping.updatePending(this.jmap, (ResourceKey<Level>)world.m_46472_());
        }
    }
}

