/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.builder;

import com.ldtteam.structurize.placement.StructurePlacer;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuilding;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class EntityAIStructureBuilder
extends AbstractEntityAIStructureWithWorkOrder<JobBuilder, BuildingBuilder> {
    private static final double SPEED_BUFF_0 = 0.5;
    private static final int ACTIONS_UNTIL_DUMP = 4096;
    private static final int LEVEL_TO_PURGE_MOBS = 4;

    public EntityAIStructureBuilder(@NotNull JobBuilder job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 100), new AITarget<Object>(AIWorkerState.START_WORKING, this::checkForWorkOrder, this::startWorkingAtOwnBuilding, 100));
        this.worker.m_21553_(true);
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public Class<BuildingBuilder> getExpectedBuildingClass() {
        return BuildingBuilder.class;
    }

    private boolean checkForWorkOrder() {
        if (!((JobBuilder)this.job).hasWorkOrder()) {
            ((BuildingBuilder)this.building).searchWorkOrder();
            ((BuildingBuilder)this.building).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return false;
        }
        IWorkOrder wo = ((JobBuilder)this.job).getWorkOrder();
        if (wo == null) {
            ((JobBuilder)this.job).setWorkOrder(null);
            ((BuildingBuilder)this.building).setProgressPos(null, null);
            return false;
        }
        IBuilding building = ((JobBuilder)this.job).getColony().getBuildingManager().getBuilding(wo.getLocation());
        if (building == null && wo instanceof WorkOrderBuilding && wo.getWorkOrderType() != WorkOrderType.REMOVE) {
            ((JobBuilder)this.job).complete();
            return false;
        }
        return true;
    }

    @Override
    public void setStructurePlacer(BuildingStructureHandler<JobBuilder, BuildingBuilder> structure) {
        if (((JobBuilder)this.job).getWorkOrder().getIteratorType().isEmpty()) {
            String mode = BuilderModeSetting.getActualValue(this.building);
            ((JobBuilder)this.job).getWorkOrder().setIteratorType(mode);
        }
        this.structurePlacer = new Tuple<StructurePlacer, BuildingStructureHandler<JobBuilder, BuildingBuilder>>(new StructurePlacer(structure, ((JobBuilder)this.job).getWorkOrder().getIteratorType()), structure);
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return !this.checkForWorkOrder();
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.LOAD_STRUCTURE;
    }

    private void killMobs() {
        if (((BuildingBuilder)this.building).getBuildingLevel() >= 4 && ((JobBuilder)this.job).getWorkOrder().getWorkOrderType() == WorkOrderType.BUILD) {
            BlockPos buildingPos = ((JobBuilder)this.job).getWorkOrder().getLocation();
            IBuilding building = this.worker.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                WorldUtil.getEntitiesWithinBuilding(this.world, Monster.class, building, null).forEach(e -> e.m_142687_(Entity.RemovalReason.DISCARDED));
            }
        }
    }

    @Override
    public void checkForExtraBuildingActions() {
        if (!((BuildingBuilder)this.building).hasPurgedMobsToday()) {
            this.killMobs();
            ((BuildingBuilder)this.building).setPurgedMobsToday(true);
        }
    }

    @Override
    protected boolean mineBlock(@NotNull BlockPos blockToMine, @NotNull BlockPos safeStand) {
        return this.mineBlock(blockToMine, safeStand, true, !IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.m_8055_(blockToMine)), null);
    }

    @Override
    public IAIState afterRequestPickUp() {
        return AIWorkerState.INVENTORY_FULL;
    }

    @Override
    public IAIState afterDump() {
        return AIWorkerState.PICK_UP;
    }

    @Override
    public boolean walkToConstructionSite(BlockPos currentBlock) {
        if (this.workFrom == null) {
            this.workFrom = this.findRandomPositionToWalkTo(5, currentBlock);
            if (this.workFrom == null && this.pathBackupFactor > 10) {
                this.workFrom = this.worker.m_20183_();
            }
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.m_20183_(), currentBlock) <= 5L + (long)this.pathBackupFactor * 5L) {
            return true;
        }
        if (this.walkToBlock(this.workFrom)) {
            return false;
        }
        if (BlockPosUtil.getDistance2D(this.worker.m_20183_(), currentBlock) > 5L + (long)this.pathBackupFactor * 5L) {
            this.workFrom = null;
            return false;
        }
        if (this.pathBackupFactor > 1) {
            --this.pathBackupFactor;
        }
        return true;
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return false;
    }

    @Override
    public int getBlockMiningDelay(@NotNull BlockState state, @NotNull BlockPos pos) {
        return (int)((double)super.getBlockMiningDelay(state, pos) * 0.5);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 4096;
    }

    @Override
    protected void sendCompletionMessage(IWorkOrder wo) {
        super.sendCompletionMessage(wo);
        BlockPos position = wo.getLocation();
        boolean showManualSuffix = false;
        if (((BuildingBuilder)this.building).getManualMode()) {
            showManualSuffix = true;
            for (IWorkOrder workorder : ((BuildingBuilder)this.building).getColony().getWorkManager().getWorkOrders().values()) {
                if (workorder.getID() == wo.getID() || !workorder.isClaimedBy(this.worker.getCitizenData())) continue;
                showManualSuffix = false;
            }
        }
        MutableComponent message = switch (wo.getWorkOrderType()) {
            case WorkOrderType.REPAIR -> Component.m_237110_((String)"entity.builder.messagerepaircomplete", (Object[])new Object[]{wo.getDisplayName(), position.m_123341_(), position.m_123342_(), position.m_123343_()});
            case WorkOrderType.REMOVE -> Component.m_237110_((String)"entity.builder.messageremovalcomplete", (Object[])new Object[]{wo.getDisplayName(), position.m_123341_(), position.m_123342_(), position.m_123343_()});
            default -> Component.m_237110_((String)"entity.builder.messagebuildcomplete", (Object[])new Object[]{wo.getDisplayName(), position.m_123341_(), position.m_123342_(), position.m_123343_()});
        };
        if (showManualSuffix) {
            message.m_7220_((Component)Component.m_237115_((String)"entity.builder.messagebuildmanualfinish"));
        }
        this.worker.getCitizenChatHandler().sendLocalizedChat((Component)message);
    }
}

