/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIHerder<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    private static final int ANIMAL_MULTIPLIER = 2;
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    private static final int EXTRA_BREEDING_ITEMS_REQUEST = 8;
    protected static final int BUTCHERING_ATTACK_DAMAGE = 5;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int BUTCHER_DELAY = 20;
    private static final int DECIDING_DELAY = 40;
    private static final int BREEDING_DELAY = 40;
    public static final int LIMIT_TO_FEED_CHILDREN = 10;
    private static final int ACTIONS_FOR_DUMP = 10;
    private static final double MAX_ENTITY_AGE = -24000.0;
    protected static final double XP_PER_ACTION = 0.5;
    @Nullable
    protected AnimalHerdingModule current_module;
    private final List<Animal> animalsToBreed = new ArrayList<Animal>();
    private int breedTimeOut = 0;

    public AbstractEntityAIHerder(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<AIWorkerState>(AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForHerding, 20), new AITarget<Object>(AIWorkerState.DECIDE, this::decideWhatToDo, 40), new AITarget<Object>(AIWorkerState.HERDER_BREED, this::breedAnimals, 40), new AITarget<Object>(AIWorkerState.HERDER_BUTCHER, this::butcherAnimals, 20), new AITarget<Object>(AIWorkerState.HERDER_PICKUP, this::pickupItems, 20), new AITarget<Object>(AIWorkerState.HERDER_FEED, this::feedAnimals, 20));
        this.worker.m_21553_(true);
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 10;
    }

    @Override
    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        List<ItemStack> list = super.itemsNiceToHave();
        if (this.building.getSetting(AbstractBuilding.BREEDING).getValue() || this.building.getSetting(AbstractBuilding.FEEDING).getValue()) {
            for (AnimalHerdingModule module : this.building.getModules(AnimalHerdingModule.class)) {
                list.addAll(this.getRequestBreedingItems(module));
            }
        }
        return list;
    }

    @NotNull
    public List<ToolType> getExtraToolsNeeded() {
        ArrayList<ToolType> toolsNeeded = new ArrayList<ToolType>();
        toolsNeeded.add(ToolType.AXE);
        return toolsNeeded;
    }

    @NotNull
    public List<ItemStack> getExtraItemsNeeded() {
        return new ArrayList<ItemStack>();
    }

    public IAIState decideWhatToDo() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        for (AnimalHerdingModule module : this.building.getModules(AnimalHerdingModule.class)) {
            boolean hasBreedingItem;
            List<Animal> animals = this.searchForAnimals(module::isCompatible);
            if (animals.isEmpty()) continue;
            this.current_module = module;
            int numOfBreedableAnimals = 0;
            int numOfFeedableAnimals = 0;
            for (Animal entity : animals) {
                if (this.isBreedAble(entity)) {
                    ++numOfBreedableAnimals;
                    continue;
                }
                if (!this.isFeedAble(entity)) continue;
                ++numOfFeedableAnimals;
            }
            boolean bl = hasBreedingItem = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStackListIgnoreStackSize(module.getBreedingItems(), stack)) > 1;
            if (!this.searchForItemsInArea().isEmpty()) {
                return AIWorkerState.HERDER_PICKUP;
            }
            if (this.maxAnimals(animals)) {
                return AIWorkerState.HERDER_BUTCHER;
            }
            if (this.canBreedChildren() && numOfBreedableAnimals >= 2 && hasBreedingItem && this.breedTimeOut == 0) {
                return AIWorkerState.HERDER_BREED;
            }
            if (!this.canFeedChildren() || numOfFeedableAnimals <= 0 || !hasBreedingItem) continue;
            return AIWorkerState.HERDER_FEED;
        }
        if (this.breedTimeOut > 0) {
            --this.breedTimeOut;
        }
        return AIWorkerState.START_WORKING;
    }

    protected boolean isBreedAble(Animal entity) {
        return entity.m_146764_() == 0 && (entity.m_27593_() || entity.m_5957_());
    }

    protected boolean isFeedAble(Animal entity) {
        return entity.m_6162_() && -24000.0 / (double)entity.m_146764_() <= 1.0 + (double)this.getSecondarySkillLevel() / 100.0;
    }

    protected boolean canBreedChildren() {
        return this.building.getSetting(AbstractBuilding.BREEDING).getValue();
    }

    protected boolean canFeedChildren() {
        return this.building.getSetting(AbstractBuilding.FEEDING).getValue() && this.getSecondarySkillLevel() >= 10;
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForHerding() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        for (ToolType tool : this.getExtraToolsNeeded()) {
            if (!this.checkForToolOrWeapon(tool)) continue;
            return this.getState();
        }
        if (this.building.getSetting(AbstractBuilding.BREEDING).getValue() || this.building.getSetting(AbstractBuilding.FEEDING).getValue()) {
            for (ItemStack breedingItem : this.current_module.getBreedingItems()) {
                this.checkIfRequestForItemExistOrCreateAsync(breedingItem, breedingItem.m_41613_() * 8, breedingItem.m_41613_());
            }
        }
        for (ItemStack item : this.getExtraItemsNeeded()) {
            this.checkIfRequestForItemExistOrCreateAsync(item);
        }
        return AIWorkerState.DECIDE;
    }

    protected IAIState butcherAnimals() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        List<Animal> animals = this.searchForAnimals(this.current_module::isCompatible);
        if (!this.maxAnimals(animals)) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(InteractionHand.MAIN_HAND, ToolType.AXE)) {
            return AIWorkerState.START_WORKING;
        }
        Animal animal = animals.stream().filter(animalToButcher -> !animalToButcher.m_6162_() && !animalToButcher.m_27593_()).findFirst().orElse(null);
        if (animal == null) {
            return AIWorkerState.DECIDE;
        }
        this.butcherAnimal(animal);
        if (!animal.m_6084_()) {
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
        }
        return AIWorkerState.HERDER_BUTCHER;
    }

    protected IAIState breedAnimals() {
        if (this.current_module == null) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.DECIDE;
        }
        if (this.breedTwoAnimals()) {
            return this.getState();
        }
        Predicate<Animal> predicate = ((Predicate<Animal>)this.current_module::isCompatible).and(this::isBreedAble);
        ArrayList<Animal> breedables = new ArrayList<Animal>(this.searchForAnimals(predicate));
        Collections.shuffle(breedables);
        Animal animalOne = breedables.stream().findAny().orElse(null);
        if (animalOne == null) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            this.breedTimeOut = 15;
            return AIWorkerState.DECIDE;
        }
        int oldAnimalOneLove = animalOne.m_27591_();
        animalOne.m_27601_(5);
        Animal animalTwo = breedables.stream().filter(animal -> {
            if (animalOne.equals(animal) || animal.m_20270_((Entity)animalOne) > 10.0f) {
                return false;
            }
            int oldLove = animal.m_27591_();
            animal.m_27601_(5);
            boolean canMate = animalOne.m_7848_(animal);
            animal.m_27601_(oldLove);
            return canMate;
        }).findAny().orElse(null);
        animalOne.m_27601_(oldAnimalOneLove);
        if (animalTwo == null) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            this.breedTimeOut = 5;
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.current_module.getBreedingItems())) {
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.START_WORKING;
        }
        this.animalsToBreed.add(animalOne);
        this.animalsToBreed.add(animalTwo);
        if (this.breedTwoAnimals()) {
            return this.getState();
        }
        this.worker.getCitizenItemHandler().removeHeldItem();
        return AIWorkerState.IDLE;
    }

    protected IAIState feedAnimals() {
        if (this.current_module == null) {
            return AIWorkerState.DECIDE;
        }
        Predicate<Animal> predicate = ((Predicate<Animal>)this.current_module::isCompatible).and(this::isFeedAble);
        Animal animalOne = this.searchForAnimals(predicate).stream().findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipItem(InteractionHand.MAIN_HAND, this.current_module.getBreedingItems())) {
            return AIWorkerState.START_WORKING;
        }
        if (!this.walkingToAnimal(animalOne)) {
            animalOne.m_146740_((int)((float)(-animalOne.m_146764_() / 20) * 0.1f), true);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.worker.m_21205_().m_41774_(1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            animalOne.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.worker.getCitizenItemHandler().removeHeldItem();
            return AIWorkerState.DECIDE;
        }
        this.worker.decreaseSaturationForContinuousAction();
        return this.getState();
    }

    private IAIState pickupItems() {
        List<ItemEntity> items = this.searchForItemsInArea();
        if (!items.isEmpty() && this.walkToBlock(items.get(0).m_20183_())) {
            return this.getState();
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    public List<? extends Animal> searchForAnimals(Predicate<Animal> predicate) {
        return WorldUtil.getEntitiesWithinBuilding(this.world, Animal.class, this.building, predicate);
    }

    public int getMaxAnimalMultiplier() {
        return 2;
    }

    public List<? extends ItemEntity> searchForItemsInArea() {
        return WorldUtil.getEntitiesWithinBuilding(this.world, ItemEntity.class, this.building, null);
    }

    public boolean walkingToAnimal(Animal animal) {
        if (animal != null) {
            return this.walkToBlock(animal.m_20183_());
        }
        return false;
    }

    private boolean breedTwoAnimals() {
        Iterator<Animal> it = this.animalsToBreed.iterator();
        while (it.hasNext()) {
            Animal animal = it.next();
            if (animal.m_27593_() || animal.m_21224_()) {
                it.remove();
                continue;
            }
            if (this.walkingToAnimal(animal)) break;
            animal.m_27595_(null);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            this.worker.m_21205_().m_41774_(1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.worker.decreaseSaturationForAction();
            it.remove();
        }
        return !this.animalsToBreed.isEmpty();
    }

    public boolean maxAnimals(List<? extends Animal> allAnimals) {
        int maxAnimals;
        List<Animal> animals = allAnimals.stream().filter(animalToButcher -> !animalToButcher.m_6162_()).toList();
        if (animals.isEmpty()) {
            return false;
        }
        int numOfAnimals = animals.size();
        return numOfAnimals > (maxAnimals = this.building.getBuildingLevel() * this.getMaxAnimalMultiplier());
    }

    public boolean equipTool(InteractionHand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), toolType, 0, this.building.getMaxToolLevel());
        if (slot == -1) {
            this.checkForToolOrWeapon(toolType);
        }
        return slot;
    }

    public boolean equipItem(InteractionHand hand, List<ItemStack> itemStacks) {
        for (ItemStack itemStack : itemStacks) {
            if (!this.checkIfRequestForItemExistOrCreateAsync(itemStack)) continue;
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.m_41720_()));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    protected void butcherAnimal(@Nullable Animal animal) {
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.m_21205_()).booleanValue()) {
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            DamageSource ds = animal.f_19853_.m_269111_().m_269075_((Player)this.getFakePlayer());
            animal.m_6469_(ds, (float)this.getButcheringAttackDamage());
            this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
        }
    }

    public double getButcheringAttackDamage() {
        return 5.0;
    }

    public List<ItemStack> getRequestBreedingItems(AnimalHerdingModule module) {
        ArrayList<ItemStack> breedingItems = new ArrayList<ItemStack>();
        for (ItemStack stack : module.getBreedingItems()) {
            ItemStack requestable = stack.m_41777_();
            ItemStackUtils.setSize(requestable, stack.m_41613_() * 8);
            breedingItems.add(requestable);
        }
        return breedingItems;
    }
}

